/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.ColumnObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class TableObject {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sync_type")
    private String syncType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="all")
    private Boolean all;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_alias_name")
    private String dbAliasName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="schema_alias_name")
    private String schemaAliasName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="filtered")
    private Boolean filtered;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="filter_conditions")
    private List<String> filterConditions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="config_conditions")
    private List<String> configConditions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_synchronized")
    private Boolean isSynchronized;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="columns")
    private Map<String, ColumnObject> columns = null;

    public TableObject withSyncType(String syncType) {
        this.syncType = syncType;
        return this;
    }

    public String getSyncType() {
        return this.syncType;
    }

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    public TableObject withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TableObject withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableObject withAll(Boolean all) {
        this.all = all;
        return this;
    }

    public Boolean getAll() {
        return this.all;
    }

    public void setAll(Boolean all) {
        this.all = all;
    }

    public TableObject withDbAliasName(String dbAliasName) {
        this.dbAliasName = dbAliasName;
        return this;
    }

    public String getDbAliasName() {
        return this.dbAliasName;
    }

    public void setDbAliasName(String dbAliasName) {
        this.dbAliasName = dbAliasName;
    }

    public TableObject withSchemaAliasName(String schemaAliasName) {
        this.schemaAliasName = schemaAliasName;
        return this;
    }

    public String getSchemaAliasName() {
        return this.schemaAliasName;
    }

    public void setSchemaAliasName(String schemaAliasName) {
        this.schemaAliasName = schemaAliasName;
    }

    public TableObject withFiltered(Boolean filtered) {
        this.filtered = filtered;
        return this;
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
    }

    public TableObject withFilterConditions(List<String> filterConditions) {
        this.filterConditions = filterConditions;
        return this;
    }

    public TableObject addFilterConditionsItem(String filterConditionsItem) {
        if (this.filterConditions == null) {
            this.filterConditions = new ArrayList<String>();
        }
        this.filterConditions.add(filterConditionsItem);
        return this;
    }

    public TableObject withFilterConditions(Consumer<List<String>> filterConditionsSetter) {
        if (this.filterConditions == null) {
            this.filterConditions = new ArrayList<String>();
        }
        filterConditionsSetter.accept(this.filterConditions);
        return this;
    }

    public List<String> getFilterConditions() {
        return this.filterConditions;
    }

    public void setFilterConditions(List<String> filterConditions) {
        this.filterConditions = filterConditions;
    }

    public TableObject withConfigConditions(List<String> configConditions) {
        this.configConditions = configConditions;
        return this;
    }

    public TableObject addConfigConditionsItem(String configConditionsItem) {
        if (this.configConditions == null) {
            this.configConditions = new ArrayList<String>();
        }
        this.configConditions.add(configConditionsItem);
        return this;
    }

    public TableObject withConfigConditions(Consumer<List<String>> configConditionsSetter) {
        if (this.configConditions == null) {
            this.configConditions = new ArrayList<String>();
        }
        configConditionsSetter.accept(this.configConditions);
        return this;
    }

    public List<String> getConfigConditions() {
        return this.configConditions;
    }

    public void setConfigConditions(List<String> configConditions) {
        this.configConditions = configConditions;
    }

    public TableObject withIsSynchronized(Boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
        return this;
    }

    public Boolean getIsSynchronized() {
        return this.isSynchronized;
    }

    public void setIsSynchronized(Boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public TableObject withColumns(Map<String, ColumnObject> columns) {
        this.columns = columns;
        return this;
    }

    public TableObject putColumnsItem(String key, ColumnObject columnsItem) {
        if (this.columns == null) {
            this.columns = new HashMap<String, ColumnObject>();
        }
        this.columns.put(key, columnsItem);
        return this;
    }

    public TableObject withColumns(Consumer<Map<String, ColumnObject>> columnsSetter) {
        if (this.columns == null) {
            this.columns = new HashMap<String, ColumnObject>();
        }
        columnsSetter.accept(this.columns);
        return this;
    }

    public Map<String, ColumnObject> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, ColumnObject> columns) {
        this.columns = columns;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableObject that = (TableObject)obj;
        return Objects.equals(this.syncType, that.syncType) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.all, that.all) && Objects.equals(this.dbAliasName, that.dbAliasName) && Objects.equals(this.schemaAliasName, that.schemaAliasName) && Objects.equals(this.filtered, that.filtered) && Objects.equals(this.filterConditions, that.filterConditions) && Objects.equals(this.configConditions, that.configConditions) && Objects.equals(this.isSynchronized, that.isSynchronized) && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.syncType, this.type, this.name, this.all, this.dbAliasName, this.schemaAliasName, this.filtered, this.filterConditions, this.configConditions, this.isSynchronized, this.columns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableObject {\n");
        sb.append("    syncType: ").append(this.toIndentedString(this.syncType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    all: ").append(this.toIndentedString(this.all)).append("\n");
        sb.append("    dbAliasName: ").append(this.toIndentedString(this.dbAliasName)).append("\n");
        sb.append("    schemaAliasName: ").append(this.toIndentedString(this.schemaAliasName)).append("\n");
        sb.append("    filtered: ").append(this.toIndentedString(this.filtered)).append("\n");
        sb.append("    filterConditions: ").append(this.toIndentedString(this.filterConditions)).append("\n");
        sb.append("    configConditions: ").append(this.toIndentedString(this.configConditions)).append("\n");
        sb.append("    isSynchronized: ").append(this.toIndentedString(this.isSynchronized)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum TABLE = new TypeEnum("table");
        public static final TypeEnum VIEW = new TypeEnum("view");
        public static final TypeEnum PROCEDURE = new TypeEnum("procedure");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("table", TABLE);
            map.put("view", VIEW);
            map.put("procedure", PROCEDURE);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

