/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.core.SdkResponse;
import com.huaweicloud.sdk.drs.v5.model.DatabaseObject;
import com.huaweicloud.sdk.drs.v5.model.TargetRootDb;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ShowDbObjectsListResponse
extends SdkResponse {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="target_root_db")
    private TargetRootDb targetRootDb;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="object_info")
    private Map<String, DatabaseObject> objectInfo = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max_table_num")
    private Integer maxTableNum;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="object_scope")
    private String objectScope;

    public ShowDbObjectsListResponse withTargetRootDb(TargetRootDb targetRootDb) {
        this.targetRootDb = targetRootDb;
        return this;
    }

    public ShowDbObjectsListResponse withTargetRootDb(Consumer<TargetRootDb> targetRootDbSetter) {
        if (this.targetRootDb == null) {
            this.targetRootDb = new TargetRootDb();
            targetRootDbSetter.accept(this.targetRootDb);
        }
        return this;
    }

    public TargetRootDb getTargetRootDb() {
        return this.targetRootDb;
    }

    public void setTargetRootDb(TargetRootDb targetRootDb) {
        this.targetRootDb = targetRootDb;
    }

    public ShowDbObjectsListResponse withObjectInfo(Map<String, DatabaseObject> objectInfo) {
        this.objectInfo = objectInfo;
        return this;
    }

    public ShowDbObjectsListResponse putObjectInfoItem(String key, DatabaseObject objectInfoItem) {
        if (this.objectInfo == null) {
            this.objectInfo = new HashMap<String, DatabaseObject>();
        }
        this.objectInfo.put(key, objectInfoItem);
        return this;
    }

    public ShowDbObjectsListResponse withObjectInfo(Consumer<Map<String, DatabaseObject>> objectInfoSetter) {
        if (this.objectInfo == null) {
            this.objectInfo = new HashMap<String, DatabaseObject>();
        }
        objectInfoSetter.accept(this.objectInfo);
        return this;
    }

    public Map<String, DatabaseObject> getObjectInfo() {
        return this.objectInfo;
    }

    public void setObjectInfo(Map<String, DatabaseObject> objectInfo) {
        this.objectInfo = objectInfo;
    }

    public ShowDbObjectsListResponse withMaxTableNum(Integer maxTableNum) {
        this.maxTableNum = maxTableNum;
        return this;
    }

    public Integer getMaxTableNum() {
        return this.maxTableNum;
    }

    public void setMaxTableNum(Integer maxTableNum) {
        this.maxTableNum = maxTableNum;
    }

    public ShowDbObjectsListResponse withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ShowDbObjectsListResponse withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ShowDbObjectsListResponse withObjectScope(String objectScope) {
        this.objectScope = objectScope;
        return this;
    }

    public String getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(String objectScope) {
        this.objectScope = objectScope;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ShowDbObjectsListResponse that = (ShowDbObjectsListResponse)((Object)obj);
        return Objects.equals(this.targetRootDb, that.targetRootDb) && Objects.equals(this.objectInfo, that.objectInfo) && Objects.equals(this.maxTableNum, that.maxTableNum) && Objects.equals(this.status, that.status) && Objects.equals(this.id, that.id) && Objects.equals(this.objectScope, that.objectScope);
    }

    public int hashCode() {
        return Objects.hash(this.targetRootDb, this.objectInfo, this.maxTableNum, this.status, this.id, this.objectScope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShowDbObjectsListResponse {\n");
        sb.append("    targetRootDb: ").append(this.toIndentedString(this.targetRootDb)).append("\n");
        sb.append("    objectInfo: ").append(this.toIndentedString(this.objectInfo)).append("\n");
        sb.append("    maxTableNum: ").append(this.toIndentedString(this.maxTableNum)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    objectScope: ").append(this.toIndentedString(this.objectScope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum SUCCESS = new StatusEnum("success");
        public static final StatusEnum _FAILED = new StatusEnum(" failed");
        public static final StatusEnum _PENDING = new StatusEnum(" pending");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("success", SUCCESS);
            map.put(" failed", _FAILED);
            map.put(" pending", _PENDING);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

