/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.BaseEndpoint;
import com.huaweicloud.sdk.drs.v5.model.BaseEndpointConfig;
import com.huaweicloud.sdk.drs.v5.model.CloudBaseInfo;
import com.huaweicloud.sdk.drs.v5.model.CloudVpcInfo;
import com.huaweicloud.sdk.drs.v5.model.CustomizedDns;
import com.huaweicloud.sdk.drs.v5.model.EndpointSslConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JobEndpointInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_type")
    private DbTypeEnum dbType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoint_type")
    private EndpointTypeEnum endpointType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoint_role")
    private EndpointRoleEnum endpointRole;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoint")
    private BaseEndpoint endpoint;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cloud")
    private CloudBaseInfo cloud;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="vpc")
    private CloudVpcInfo vpc;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="config")
    private BaseEndpointConfig config;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ssl")
    private EndpointSslConfig ssl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="customized_dns")
    private CustomizedDns customizedDns;

    public JobEndpointInfo withDbType(DbTypeEnum dbType) {
        this.dbType = dbType;
        return this;
    }

    public DbTypeEnum getDbType() {
        return this.dbType;
    }

    public void setDbType(DbTypeEnum dbType) {
        this.dbType = dbType;
    }

    public JobEndpointInfo withEndpointType(EndpointTypeEnum endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public EndpointTypeEnum getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(EndpointTypeEnum endpointType) {
        this.endpointType = endpointType;
    }

    public JobEndpointInfo withEndpointRole(EndpointRoleEnum endpointRole) {
        this.endpointRole = endpointRole;
        return this;
    }

    public EndpointRoleEnum getEndpointRole() {
        return this.endpointRole;
    }

    public void setEndpointRole(EndpointRoleEnum endpointRole) {
        this.endpointRole = endpointRole;
    }

    public JobEndpointInfo withEndpoint(BaseEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public JobEndpointInfo withEndpoint(Consumer<BaseEndpoint> endpointSetter) {
        if (this.endpoint == null) {
            this.endpoint = new BaseEndpoint();
            endpointSetter.accept(this.endpoint);
        }
        return this;
    }

    public BaseEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(BaseEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public JobEndpointInfo withCloud(CloudBaseInfo cloud) {
        this.cloud = cloud;
        return this;
    }

    public JobEndpointInfo withCloud(Consumer<CloudBaseInfo> cloudSetter) {
        if (this.cloud == null) {
            this.cloud = new CloudBaseInfo();
            cloudSetter.accept(this.cloud);
        }
        return this;
    }

    public CloudBaseInfo getCloud() {
        return this.cloud;
    }

    public void setCloud(CloudBaseInfo cloud) {
        this.cloud = cloud;
    }

    public JobEndpointInfo withVpc(CloudVpcInfo vpc) {
        this.vpc = vpc;
        return this;
    }

    public JobEndpointInfo withVpc(Consumer<CloudVpcInfo> vpcSetter) {
        if (this.vpc == null) {
            this.vpc = new CloudVpcInfo();
            vpcSetter.accept(this.vpc);
        }
        return this;
    }

    public CloudVpcInfo getVpc() {
        return this.vpc;
    }

    public void setVpc(CloudVpcInfo vpc) {
        this.vpc = vpc;
    }

    public JobEndpointInfo withConfig(BaseEndpointConfig config) {
        this.config = config;
        return this;
    }

    public JobEndpointInfo withConfig(Consumer<BaseEndpointConfig> configSetter) {
        if (this.config == null) {
            this.config = new BaseEndpointConfig();
            configSetter.accept(this.config);
        }
        return this;
    }

    public BaseEndpointConfig getConfig() {
        return this.config;
    }

    public void setConfig(BaseEndpointConfig config) {
        this.config = config;
    }

    public JobEndpointInfo withSsl(EndpointSslConfig ssl) {
        this.ssl = ssl;
        return this;
    }

    public JobEndpointInfo withSsl(Consumer<EndpointSslConfig> sslSetter) {
        if (this.ssl == null) {
            this.ssl = new EndpointSslConfig();
            sslSetter.accept(this.ssl);
        }
        return this;
    }

    public EndpointSslConfig getSsl() {
        return this.ssl;
    }

    public void setSsl(EndpointSslConfig ssl) {
        this.ssl = ssl;
    }

    public JobEndpointInfo withCustomizedDns(CustomizedDns customizedDns) {
        this.customizedDns = customizedDns;
        return this;
    }

    public JobEndpointInfo withCustomizedDns(Consumer<CustomizedDns> customizedDnsSetter) {
        if (this.customizedDns == null) {
            this.customizedDns = new CustomizedDns();
            customizedDnsSetter.accept(this.customizedDns);
        }
        return this;
    }

    public CustomizedDns getCustomizedDns() {
        return this.customizedDns;
    }

    public void setCustomizedDns(CustomizedDns customizedDns) {
        this.customizedDns = customizedDns;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobEndpointInfo that = (JobEndpointInfo)obj;
        return Objects.equals(this.dbType, that.dbType) && Objects.equals(this.endpointType, that.endpointType) && Objects.equals(this.endpointRole, that.endpointRole) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.cloud, that.cloud) && Objects.equals(this.vpc, that.vpc) && Objects.equals(this.config, that.config) && Objects.equals(this.ssl, that.ssl) && Objects.equals(this.customizedDns, that.customizedDns);
    }

    public int hashCode() {
        return Objects.hash(this.dbType, this.endpointType, this.endpointRole, this.endpoint, this.cloud, this.vpc, this.config, this.ssl, this.customizedDns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobEndpointInfo {\n");
        sb.append("    dbType: ").append(this.toIndentedString(this.dbType)).append("\n");
        sb.append("    endpointType: ").append(this.toIndentedString(this.endpointType)).append("\n");
        sb.append("    endpointRole: ").append(this.toIndentedString(this.endpointRole)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    cloud: ").append(this.toIndentedString(this.cloud)).append("\n");
        sb.append("    vpc: ").append(this.toIndentedString(this.vpc)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    ssl: ").append(this.toIndentedString(this.ssl)).append("\n");
        sb.append("    customizedDns: ").append(this.toIndentedString(this.customizedDns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EndpointRoleEnum {
        public static final EndpointRoleEnum SO = new EndpointRoleEnum("so");
        public static final EndpointRoleEnum TA = new EndpointRoleEnum("ta");
        private static final Map<String, EndpointRoleEnum> STATIC_FIELDS = EndpointRoleEnum.createStaticFields();
        private String value;

        private static Map<String, EndpointRoleEnum> createStaticFields() {
            HashMap<String, EndpointRoleEnum> map = new HashMap<String, EndpointRoleEnum>();
            map.put("so", SO);
            map.put("ta", TA);
            return Collections.unmodifiableMap(map);
        }

        EndpointRoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EndpointRoleEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EndpointRoleEnum(value));
        }

        public static EndpointRoleEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EndpointRoleEnum) {
                return this.value.equals(((EndpointRoleEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class EndpointTypeEnum {
        public static final EndpointTypeEnum OFFLINE = new EndpointTypeEnum("offline");
        public static final EndpointTypeEnum ECS = new EndpointTypeEnum("ecs");
        public static final EndpointTypeEnum CLOUD = new EndpointTypeEnum("cloud");
        private static final Map<String, EndpointTypeEnum> STATIC_FIELDS = EndpointTypeEnum.createStaticFields();
        private String value;

        private static Map<String, EndpointTypeEnum> createStaticFields() {
            HashMap<String, EndpointTypeEnum> map = new HashMap<String, EndpointTypeEnum>();
            map.put("offline", OFFLINE);
            map.put("ecs", ECS);
            map.put("cloud", CLOUD);
            return Collections.unmodifiableMap(map);
        }

        EndpointTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EndpointTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EndpointTypeEnum(value));
        }

        public static EndpointTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EndpointTypeEnum) {
                return this.value.equals(((EndpointTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class DbTypeEnum {
        public static final DbTypeEnum ORACLE = new DbTypeEnum("oracle");
        public static final DbTypeEnum GAUSSDBV5 = new DbTypeEnum("gaussdbv5");
        public static final DbTypeEnum REDIS = new DbTypeEnum("redis");
        public static final DbTypeEnum REDISCLUSTER = new DbTypeEnum("rediscluster");
        public static final DbTypeEnum GAUSSREDIS = new DbTypeEnum("gaussredis");
        public static final DbTypeEnum MYSQL = new DbTypeEnum("mysql");
        private static final Map<String, DbTypeEnum> STATIC_FIELDS = DbTypeEnum.createStaticFields();
        private String value;

        private static Map<String, DbTypeEnum> createStaticFields() {
            HashMap<String, DbTypeEnum> map = new HashMap<String, DbTypeEnum>();
            map.put("oracle", ORACLE);
            map.put("gaussdbv5", GAUSSDBV5);
            map.put("redis", REDIS);
            map.put("rediscluster", REDISCLUSTER);
            map.put("gaussredis", GAUSSREDIS);
            map.put("mysql", MYSQL);
            return Collections.unmodifiableMap(map);
        }

        DbTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DbTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DbTypeEnum(value));
        }

        public static DbTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DbTypeEnum) {
                return this.value.equals(((DbTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

