/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JobActions {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="available_actions")
    private List<String> availableActions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="unavailable_actions")
    private List<String> unavailableActions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="current_action")
    private CurrentActionEnum currentAction;

    public JobActions withAvailableActions(List<String> availableActions) {
        this.availableActions = availableActions;
        return this;
    }

    public JobActions addAvailableActionsItem(String availableActionsItem) {
        if (this.availableActions == null) {
            this.availableActions = new ArrayList<String>();
        }
        this.availableActions.add(availableActionsItem);
        return this;
    }

    public JobActions withAvailableActions(Consumer<List<String>> availableActionsSetter) {
        if (this.availableActions == null) {
            this.availableActions = new ArrayList<String>();
        }
        availableActionsSetter.accept(this.availableActions);
        return this;
    }

    public List<String> getAvailableActions() {
        return this.availableActions;
    }

    public void setAvailableActions(List<String> availableActions) {
        this.availableActions = availableActions;
    }

    public JobActions withUnavailableActions(List<String> unavailableActions) {
        this.unavailableActions = unavailableActions;
        return this;
    }

    public JobActions addUnavailableActionsItem(String unavailableActionsItem) {
        if (this.unavailableActions == null) {
            this.unavailableActions = new ArrayList<String>();
        }
        this.unavailableActions.add(unavailableActionsItem);
        return this;
    }

    public JobActions withUnavailableActions(Consumer<List<String>> unavailableActionsSetter) {
        if (this.unavailableActions == null) {
            this.unavailableActions = new ArrayList<String>();
        }
        unavailableActionsSetter.accept(this.unavailableActions);
        return this;
    }

    public List<String> getUnavailableActions() {
        return this.unavailableActions;
    }

    public void setUnavailableActions(List<String> unavailableActions) {
        this.unavailableActions = unavailableActions;
    }

    public JobActions withCurrentAction(CurrentActionEnum currentAction) {
        this.currentAction = currentAction;
        return this;
    }

    public CurrentActionEnum getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(CurrentActionEnum currentAction) {
        this.currentAction = currentAction;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobActions that = (JobActions)obj;
        return Objects.equals(this.availableActions, that.availableActions) && Objects.equals(this.unavailableActions, that.unavailableActions) && Objects.equals(this.currentAction, that.currentAction);
    }

    public int hashCode() {
        return Objects.hash(this.availableActions, this.unavailableActions, this.currentAction);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobActions {\n");
        sb.append("    availableActions: ").append(this.toIndentedString(this.availableActions)).append("\n");
        sb.append("    unavailableActions: ").append(this.toIndentedString(this.unavailableActions)).append("\n");
        sb.append("    currentAction: ").append(this.toIndentedString(this.currentAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class CurrentActionEnum {
        public static final CurrentActionEnum API_CONFIGURATION_ACTION = new CurrentActionEnum("API_CONFIGURATION_ACTION");
        public static final CurrentActionEnum CHANGE = new CurrentActionEnum("CHANGE");
        public static final CurrentActionEnum CHANGE_MODE = new CurrentActionEnum("CHANGE_MODE");
        public static final CurrentActionEnum CHOOSE_OBJECT = new CurrentActionEnum("CHOOSE_OBJECT");
        public static final CurrentActionEnum CLONE = new CurrentActionEnum("CLONE");
        public static final CurrentActionEnum CONTINUE_APPLY = new CurrentActionEnum("CONTINUE_APPLY");
        public static final CurrentActionEnum CONTINUE_CAPTURE = new CurrentActionEnum("CONTINUE_CAPTURE");
        public static final CurrentActionEnum CONTINUE_JOB = new CurrentActionEnum("CONTINUE_JOB");
        public static final CurrentActionEnum CREATE = new CurrentActionEnum("CREATE");
        public static final CurrentActionEnum DELETE = new CurrentActionEnum("DELETE");
        public static final CurrentActionEnum FREE_RESOURCE = new CurrentActionEnum("FREE_RESOURCE");
        public static final CurrentActionEnum JUMP_RETRY = new CurrentActionEnum("JUMP_RETRY");
        public static final CurrentActionEnum MODIFY_CONFIGURATION = new CurrentActionEnum("MODIFY_CONFIGURATION");
        public static final CurrentActionEnum MODIFY_DB_CONFIG = new CurrentActionEnum("MODIFY_DB_CONFIG");
        public static final CurrentActionEnum MODIFY_TASK_NUMBER = new CurrentActionEnum("MODIFY_TASK_NUMBER");
        public static final CurrentActionEnum NODE_FLAVOR_MODIFY = new CurrentActionEnum("NODE_FLAVOR_MODIFY");
        public static final CurrentActionEnum ORDER_INFO = new CurrentActionEnum("ORDER_INFO");
        public static final CurrentActionEnum PAUSE = new CurrentActionEnum("PAUSE");
        public static final CurrentActionEnum PAY_ORDER = new CurrentActionEnum("PAY_ORDER");
        public static final CurrentActionEnum PRE_CHECK = new CurrentActionEnum("PRE_CHECK");
        public static final CurrentActionEnum QUERY_PRE_CHECK = new CurrentActionEnum("QUERY_PRE_CHECK");
        public static final CurrentActionEnum RESET = new CurrentActionEnum("RESET");
        public static final CurrentActionEnum RESET_DB_PWD = new CurrentActionEnum("RESET_DB_PWD");
        public static final CurrentActionEnum RETRY = new CurrentActionEnum("RETRY");
        public static final CurrentActionEnum START = new CurrentActionEnum("START");
        public static final CurrentActionEnum START_INCR = new CurrentActionEnum("START_INCR");
        public static final CurrentActionEnum STOP_APPLY = new CurrentActionEnum("STOP_APPLY");
        public static final CurrentActionEnum STOP_CAPTURE = new CurrentActionEnum("STOP_CAPTURE");
        public static final CurrentActionEnum STOP_JOB = new CurrentActionEnum("STOP_JOB");
        public static final CurrentActionEnum SWITCH_OVER = new CurrentActionEnum("SWITCH_OVER");
        public static final CurrentActionEnum TO_PERIOD = new CurrentActionEnum("TO_PERIOD");
        public static final CurrentActionEnum TO_RENEW = new CurrentActionEnum("TO_RENEW");
        public static final CurrentActionEnum UNSUBSCRIBE = new CurrentActionEnum("UNSUBSCRIBE");
        private static final Map<String, CurrentActionEnum> STATIC_FIELDS = CurrentActionEnum.createStaticFields();
        private String value;

        private static Map<String, CurrentActionEnum> createStaticFields() {
            HashMap<String, CurrentActionEnum> map = new HashMap<String, CurrentActionEnum>();
            map.put("API_CONFIGURATION_ACTION", API_CONFIGURATION_ACTION);
            map.put("CHANGE", CHANGE);
            map.put("CHANGE_MODE", CHANGE_MODE);
            map.put("CHOOSE_OBJECT", CHOOSE_OBJECT);
            map.put("CLONE", CLONE);
            map.put("CONTINUE_APPLY", CONTINUE_APPLY);
            map.put("CONTINUE_CAPTURE", CONTINUE_CAPTURE);
            map.put("CONTINUE_JOB", CONTINUE_JOB);
            map.put("CREATE", CREATE);
            map.put("DELETE", DELETE);
            map.put("FREE_RESOURCE", FREE_RESOURCE);
            map.put("JUMP_RETRY", JUMP_RETRY);
            map.put("MODIFY_CONFIGURATION", MODIFY_CONFIGURATION);
            map.put("MODIFY_DB_CONFIG", MODIFY_DB_CONFIG);
            map.put("MODIFY_TASK_NUMBER", MODIFY_TASK_NUMBER);
            map.put("NODE_FLAVOR_MODIFY", NODE_FLAVOR_MODIFY);
            map.put("ORDER_INFO", ORDER_INFO);
            map.put("PAUSE", PAUSE);
            map.put("PAY_ORDER", PAY_ORDER);
            map.put("PRE_CHECK", PRE_CHECK);
            map.put("QUERY_PRE_CHECK", QUERY_PRE_CHECK);
            map.put("RESET", RESET);
            map.put("RESET_DB_PWD", RESET_DB_PWD);
            map.put("RETRY", RETRY);
            map.put("START", START);
            map.put("START_INCR", START_INCR);
            map.put("STOP_APPLY", STOP_APPLY);
            map.put("STOP_CAPTURE", STOP_CAPTURE);
            map.put("STOP_JOB", STOP_JOB);
            map.put("SWITCH_OVER", SWITCH_OVER);
            map.put("TO_PERIOD", TO_PERIOD);
            map.put("TO_RENEW", TO_RENEW);
            map.put("UNSUBSCRIBE", UNSUBSCRIBE);
            return Collections.unmodifiableMap(map);
        }

        CurrentActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrentActionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new CurrentActionEnum(value));
        }

        public static CurrentActionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CurrentActionEnum) {
                return this.value.equals(((CurrentActionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

