/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.DatabaseObject;
import com.huaweicloud.sdk.drs.v5.model.TargetRootDb;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DbObject {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="object_scope")
    private ObjectScopeEnum objectScope;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="target_root_db")
    private TargetRootDb targetRootDb;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="object_info")
    private Map<String, DatabaseObject> objectInfo = null;

    public DbObject withObjectScope(ObjectScopeEnum objectScope) {
        this.objectScope = objectScope;
        return this;
    }

    public ObjectScopeEnum getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(ObjectScopeEnum objectScope) {
        this.objectScope = objectScope;
    }

    public DbObject withTargetRootDb(TargetRootDb targetRootDb) {
        this.targetRootDb = targetRootDb;
        return this;
    }

    public DbObject withTargetRootDb(Consumer<TargetRootDb> targetRootDbSetter) {
        if (this.targetRootDb == null) {
            this.targetRootDb = new TargetRootDb();
            targetRootDbSetter.accept(this.targetRootDb);
        }
        return this;
    }

    public TargetRootDb getTargetRootDb() {
        return this.targetRootDb;
    }

    public void setTargetRootDb(TargetRootDb targetRootDb) {
        this.targetRootDb = targetRootDb;
    }

    public DbObject withObjectInfo(Map<String, DatabaseObject> objectInfo) {
        this.objectInfo = objectInfo;
        return this;
    }

    public DbObject putObjectInfoItem(String key, DatabaseObject objectInfoItem) {
        if (this.objectInfo == null) {
            this.objectInfo = new HashMap<String, DatabaseObject>();
        }
        this.objectInfo.put(key, objectInfoItem);
        return this;
    }

    public DbObject withObjectInfo(Consumer<Map<String, DatabaseObject>> objectInfoSetter) {
        if (this.objectInfo == null) {
            this.objectInfo = new HashMap<String, DatabaseObject>();
        }
        objectInfoSetter.accept(this.objectInfo);
        return this;
    }

    public Map<String, DatabaseObject> getObjectInfo() {
        return this.objectInfo;
    }

    public void setObjectInfo(Map<String, DatabaseObject> objectInfo) {
        this.objectInfo = objectInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DbObject that = (DbObject)obj;
        return Objects.equals(this.objectScope, that.objectScope) && Objects.equals(this.targetRootDb, that.targetRootDb) && Objects.equals(this.objectInfo, that.objectInfo);
    }

    public int hashCode() {
        return Objects.hash(this.objectScope, this.targetRootDb, this.objectInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DbObject {\n");
        sb.append("    objectScope: ").append(this.toIndentedString(this.objectScope)).append("\n");
        sb.append("    targetRootDb: ").append(this.toIndentedString(this.targetRootDb)).append("\n");
        sb.append("    objectInfo: ").append(this.toIndentedString(this.objectInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ObjectScopeEnum {
        public static final ObjectScopeEnum ALL = new ObjectScopeEnum("all");
        public static final ObjectScopeEnum DATABASE = new ObjectScopeEnum("database");
        public static final ObjectScopeEnum TABLE = new ObjectScopeEnum("table");
        private static final Map<String, ObjectScopeEnum> STATIC_FIELDS = ObjectScopeEnum.createStaticFields();
        private String value;

        private static Map<String, ObjectScopeEnum> createStaticFields() {
            HashMap<String, ObjectScopeEnum> map = new HashMap<String, ObjectScopeEnum>();
            map.put("all", ALL);
            map.put("database", DATABASE);
            map.put("table", TABLE);
            return Collections.unmodifiableMap(map);
        }

        ObjectScopeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectScopeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ObjectScopeEnum(value));
        }

        public static ObjectScopeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectScopeEnum) {
                return this.value.equals(((ObjectScopeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

