/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.SchemaObject;
import com.huaweicloud.sdk.drs.v5.model.TableObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DatabaseObject {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sync_type")
    private SyncTypeEnum syncType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="all")
    private Boolean all;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="schemas")
    private Map<String, SchemaObject> schemas = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tables")
    private Map<String, TableObject> tables = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="total_table_num")
    private Integer totalTableNum;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_synchronized")
    private Boolean isSynchronized;

    public DatabaseObject withSyncType(SyncTypeEnum syncType) {
        this.syncType = syncType;
        return this;
    }

    public SyncTypeEnum getSyncType() {
        return this.syncType;
    }

    public void setSyncType(SyncTypeEnum syncType) {
        this.syncType = syncType;
    }

    public DatabaseObject withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatabaseObject withAll(Boolean all) {
        this.all = all;
        return this;
    }

    public Boolean getAll() {
        return this.all;
    }

    public void setAll(Boolean all) {
        this.all = all;
    }

    public DatabaseObject withSchemas(Map<String, SchemaObject> schemas) {
        this.schemas = schemas;
        return this;
    }

    public DatabaseObject putSchemasItem(String key, SchemaObject schemasItem) {
        if (this.schemas == null) {
            this.schemas = new HashMap<String, SchemaObject>();
        }
        this.schemas.put(key, schemasItem);
        return this;
    }

    public DatabaseObject withSchemas(Consumer<Map<String, SchemaObject>> schemasSetter) {
        if (this.schemas == null) {
            this.schemas = new HashMap<String, SchemaObject>();
        }
        schemasSetter.accept(this.schemas);
        return this;
    }

    public Map<String, SchemaObject> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Map<String, SchemaObject> schemas) {
        this.schemas = schemas;
    }

    public DatabaseObject withTables(Map<String, TableObject> tables) {
        this.tables = tables;
        return this;
    }

    public DatabaseObject putTablesItem(String key, TableObject tablesItem) {
        if (this.tables == null) {
            this.tables = new HashMap<String, TableObject>();
        }
        this.tables.put(key, tablesItem);
        return this;
    }

    public DatabaseObject withTables(Consumer<Map<String, TableObject>> tablesSetter) {
        if (this.tables == null) {
            this.tables = new HashMap<String, TableObject>();
        }
        tablesSetter.accept(this.tables);
        return this;
    }

    public Map<String, TableObject> getTables() {
        return this.tables;
    }

    public void setTables(Map<String, TableObject> tables) {
        this.tables = tables;
    }

    public DatabaseObject withTotalTableNum(Integer totalTableNum) {
        this.totalTableNum = totalTableNum;
        return this;
    }

    public Integer getTotalTableNum() {
        return this.totalTableNum;
    }

    public void setTotalTableNum(Integer totalTableNum) {
        this.totalTableNum = totalTableNum;
    }

    public DatabaseObject withIsSynchronized(Boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
        return this;
    }

    public Boolean getIsSynchronized() {
        return this.isSynchronized;
    }

    public void setIsSynchronized(Boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseObject that = (DatabaseObject)obj;
        return Objects.equals(this.syncType, that.syncType) && Objects.equals(this.name, that.name) && Objects.equals(this.all, that.all) && Objects.equals(this.schemas, that.schemas) && Objects.equals(this.tables, that.tables) && Objects.equals(this.totalTableNum, that.totalTableNum) && Objects.equals(this.isSynchronized, that.isSynchronized);
    }

    public int hashCode() {
        return Objects.hash(this.syncType, this.name, this.all, this.schemas, this.tables, this.totalTableNum, this.isSynchronized);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatabaseObject {\n");
        sb.append("    syncType: ").append(this.toIndentedString(this.syncType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    all: ").append(this.toIndentedString(this.all)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    totalTableNum: ").append(this.toIndentedString(this.totalTableNum)).append("\n");
        sb.append("    isSynchronized: ").append(this.toIndentedString(this.isSynchronized)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SyncTypeEnum {
        public static final SyncTypeEnum CONFIG = new SyncTypeEnum("config");
        private static final Map<String, SyncTypeEnum> STATIC_FIELDS = SyncTypeEnum.createStaticFields();
        private String value;

        private static Map<String, SyncTypeEnum> createStaticFields() {
            HashMap<String, SyncTypeEnum> map = new HashMap<String, SyncTypeEnum>();
            map.put("config", CONFIG);
            return Collections.unmodifiableMap(map);
        }

        SyncTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SyncTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SyncTypeEnum(value));
        }

        public static SyncTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SyncTypeEnum) {
                return this.value.equals(((SyncTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

