/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.DataProcessInfo;
import com.huaweicloud.sdk.drs.v5.model.DatabaseObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CompareTaskParams {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="compare_task_id")
    private String compareTaskId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="start_time")
    private String startTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="option")
    private Map<String, String> option = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_object")
    private Map<String, DatabaseObject> dbObject = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data_process_info")
    private List<DataProcessInfo> dataProcessInfo = null;

    public CompareTaskParams withCompareTaskId(String compareTaskId) {
        this.compareTaskId = compareTaskId;
        return this;
    }

    public String getCompareTaskId() {
        return this.compareTaskId;
    }

    public void setCompareTaskId(String compareTaskId) {
        this.compareTaskId = compareTaskId;
    }

    public CompareTaskParams withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CompareTaskParams withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public CompareTaskParams withOption(Map<String, String> option) {
        this.option = option;
        return this;
    }

    public CompareTaskParams putOptionItem(String key, String optionItem) {
        if (this.option == null) {
            this.option = new HashMap<String, String>();
        }
        this.option.put(key, optionItem);
        return this;
    }

    public CompareTaskParams withOption(Consumer<Map<String, String>> optionSetter) {
        if (this.option == null) {
            this.option = new HashMap<String, String>();
        }
        optionSetter.accept(this.option);
        return this;
    }

    public Map<String, String> getOption() {
        return this.option;
    }

    public void setOption(Map<String, String> option) {
        this.option = option;
    }

    public CompareTaskParams withDbObject(Map<String, DatabaseObject> dbObject) {
        this.dbObject = dbObject;
        return this;
    }

    public CompareTaskParams putDbObjectItem(String key, DatabaseObject dbObjectItem) {
        if (this.dbObject == null) {
            this.dbObject = new HashMap<String, DatabaseObject>();
        }
        this.dbObject.put(key, dbObjectItem);
        return this;
    }

    public CompareTaskParams withDbObject(Consumer<Map<String, DatabaseObject>> dbObjectSetter) {
        if (this.dbObject == null) {
            this.dbObject = new HashMap<String, DatabaseObject>();
        }
        dbObjectSetter.accept(this.dbObject);
        return this;
    }

    public Map<String, DatabaseObject> getDbObject() {
        return this.dbObject;
    }

    public void setDbObject(Map<String, DatabaseObject> dbObject) {
        this.dbObject = dbObject;
    }

    public CompareTaskParams withDataProcessInfo(List<DataProcessInfo> dataProcessInfo) {
        this.dataProcessInfo = dataProcessInfo;
        return this;
    }

    public CompareTaskParams addDataProcessInfoItem(DataProcessInfo dataProcessInfoItem) {
        if (this.dataProcessInfo == null) {
            this.dataProcessInfo = new ArrayList<DataProcessInfo>();
        }
        this.dataProcessInfo.add(dataProcessInfoItem);
        return this;
    }

    public CompareTaskParams withDataProcessInfo(Consumer<List<DataProcessInfo>> dataProcessInfoSetter) {
        if (this.dataProcessInfo == null) {
            this.dataProcessInfo = new ArrayList<DataProcessInfo>();
        }
        dataProcessInfoSetter.accept(this.dataProcessInfo);
        return this;
    }

    public List<DataProcessInfo> getDataProcessInfo() {
        return this.dataProcessInfo;
    }

    public void setDataProcessInfo(List<DataProcessInfo> dataProcessInfo) {
        this.dataProcessInfo = dataProcessInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompareTaskParams that = (CompareTaskParams)obj;
        return Objects.equals(this.compareTaskId, that.compareTaskId) && Objects.equals(this.type, that.type) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.option, that.option) && Objects.equals(this.dbObject, that.dbObject) && Objects.equals(this.dataProcessInfo, that.dataProcessInfo);
    }

    public int hashCode() {
        return Objects.hash(this.compareTaskId, this.type, this.startTime, this.option, this.dbObject, this.dataProcessInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompareTaskParams {\n");
        sb.append("    compareTaskId: ").append(this.toIndentedString(this.compareTaskId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    option: ").append(this.toIndentedString(this.option)).append("\n");
        sb.append("    dbObject: ").append(this.toIndentedString(this.dbObject)).append("\n");
        sb.append("    dataProcessInfo: ").append(this.toIndentedString(this.dataProcessInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum OBJECT = new TypeEnum("object");
        public static final TypeEnum LINES = new TypeEnum("lines");
        public static final TypeEnum CONTENTS = new TypeEnum("contents");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("object", OBJECT);
            map.put("lines", LINES);
            map.put("contents", CONTENTS);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

