/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BaseEndpoint {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoint_name")
    private EndpointNameEnum endpointName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ip")
    private String ip;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_port")
    private String dbPort;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_user")
    private String dbUser;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_password")
    private String dbPassword;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instance_name")
    private String instanceName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="db_name")
    private String dbName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source_sharding")
    private List<BaseEndpoint> sourceSharding = null;

    public BaseEndpoint withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BaseEndpoint withEndpointName(EndpointNameEnum endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public EndpointNameEnum getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(EndpointNameEnum endpointName) {
        this.endpointName = endpointName;
    }

    public BaseEndpoint withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public BaseEndpoint withDbPort(String dbPort) {
        this.dbPort = dbPort;
        return this;
    }

    public String getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }

    public BaseEndpoint withDbUser(String dbUser) {
        this.dbUser = dbUser;
        return this;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public BaseEndpoint withDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
        return this;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public BaseEndpoint withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public BaseEndpoint withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public BaseEndpoint withDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public BaseEndpoint withSourceSharding(List<BaseEndpoint> sourceSharding) {
        this.sourceSharding = sourceSharding;
        return this;
    }

    public BaseEndpoint addSourceShardingItem(BaseEndpoint sourceShardingItem) {
        if (this.sourceSharding == null) {
            this.sourceSharding = new ArrayList<BaseEndpoint>();
        }
        this.sourceSharding.add(sourceShardingItem);
        return this;
    }

    public BaseEndpoint withSourceSharding(Consumer<List<BaseEndpoint>> sourceShardingSetter) {
        if (this.sourceSharding == null) {
            this.sourceSharding = new ArrayList<BaseEndpoint>();
        }
        sourceShardingSetter.accept(this.sourceSharding);
        return this;
    }

    public List<BaseEndpoint> getSourceSharding() {
        return this.sourceSharding;
    }

    public void setSourceSharding(List<BaseEndpoint> sourceSharding) {
        this.sourceSharding = sourceSharding;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEndpoint that = (BaseEndpoint)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.endpointName, that.endpointName) && Objects.equals(this.ip, that.ip) && Objects.equals(this.dbPort, that.dbPort) && Objects.equals(this.dbUser, that.dbUser) && Objects.equals(this.dbPassword, that.dbPassword) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.instanceName, that.instanceName) && Objects.equals(this.dbName, that.dbName) && Objects.equals(this.sourceSharding, that.sourceSharding);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.endpointName, this.ip, this.dbPort, this.dbUser, this.dbPassword, this.instanceId, this.instanceName, this.dbName, this.sourceSharding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseEndpoint {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    endpointName: ").append(this.toIndentedString(this.endpointName)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    dbPort: ").append(this.toIndentedString(this.dbPort)).append("\n");
        sb.append("    dbUser: ").append(this.toIndentedString(this.dbUser)).append("\n");
        sb.append("    dbPassword: ").append(this.toIndentedString(this.dbPassword)).append("\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    instanceName: ").append(this.toIndentedString(this.instanceName)).append("\n");
        sb.append("    dbName: ").append(this.toIndentedString(this.dbName)).append("\n");
        sb.append("    sourceSharding: ").append(this.toIndentedString(this.sourceSharding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EndpointNameEnum {
        public static final EndpointNameEnum ORACLE = new EndpointNameEnum("oracle");
        public static final EndpointNameEnum ECS_ORACLE = new EndpointNameEnum("ecs_oracle");
        public static final EndpointNameEnum CLOUD_GAUSSDBV5 = new EndpointNameEnum("cloud_gaussdbv5");
        public static final EndpointNameEnum MYSQL = new EndpointNameEnum("mysql");
        public static final EndpointNameEnum ECS_MYSQL = new EndpointNameEnum("ecs_mysql");
        public static final EndpointNameEnum CLOUD_MYSQL = new EndpointNameEnum("cloud_mysql");
        public static final EndpointNameEnum REDIS = new EndpointNameEnum("redis");
        public static final EndpointNameEnum ECS_REDIS = new EndpointNameEnum("ecs_redis");
        public static final EndpointNameEnum REDISCLUSTER = new EndpointNameEnum("rediscluster");
        public static final EndpointNameEnum ECS_REDISCLUSTER = new EndpointNameEnum("ecs_rediscluster");
        public static final EndpointNameEnum CLOUD_GAUSSDB_REDIS = new EndpointNameEnum("cloud_gaussdb_redis");
        public static final EndpointNameEnum POSTGRESQL = new EndpointNameEnum("postgresql");
        public static final EndpointNameEnum ECS_POSTGRESQL = new EndpointNameEnum("ecs_postgresql");
        public static final EndpointNameEnum CLOUD_POSTGRESQL = new EndpointNameEnum("cloud_postgresql");
        public static final EndpointNameEnum MONGODB = new EndpointNameEnum("mongodb");
        public static final EndpointNameEnum ECS_MONGODB = new EndpointNameEnum("ecs_mongodb");
        public static final EndpointNameEnum CLOUD_MONGODB = new EndpointNameEnum("cloud_mongodb");
        private static final Map<String, EndpointNameEnum> STATIC_FIELDS = EndpointNameEnum.createStaticFields();
        private String value;

        private static Map<String, EndpointNameEnum> createStaticFields() {
            HashMap<String, EndpointNameEnum> map = new HashMap<String, EndpointNameEnum>();
            map.put("oracle", ORACLE);
            map.put("ecs_oracle", ECS_ORACLE);
            map.put("cloud_gaussdbv5", CLOUD_GAUSSDBV5);
            map.put("mysql", MYSQL);
            map.put("ecs_mysql", ECS_MYSQL);
            map.put("cloud_mysql", CLOUD_MYSQL);
            map.put("redis", REDIS);
            map.put("ecs_redis", ECS_REDIS);
            map.put("rediscluster", REDISCLUSTER);
            map.put("ecs_rediscluster", ECS_REDISCLUSTER);
            map.put("cloud_gaussdb_redis", CLOUD_GAUSSDB_REDIS);
            map.put("postgresql", POSTGRESQL);
            map.put("ecs_postgresql", ECS_POSTGRESQL);
            map.put("cloud_postgresql", CLOUD_POSTGRESQL);
            map.put("mongodb", MONGODB);
            map.put("ecs_mongodb", ECS_MONGODB);
            map.put("cloud_mongodb", CLOUD_MONGODB);
            return Collections.unmodifiableMap(map);
        }

        EndpointNameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EndpointNameEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EndpointNameEnum(value));
        }

        public static EndpointNameEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EndpointNameEnum) {
                return this.value.equals(((EndpointNameEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

