/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.ResourceTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BackupJobBaseInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="engine_type")
    private EngineTypeEnum engineType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tags")
    private List<ResourceTag> tags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;

    public BackupJobBaseInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BackupJobBaseInfo withEngineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
        return this;
    }

    public EngineTypeEnum getEngineType() {
        return this.engineType;
    }

    public void setEngineType(EngineTypeEnum engineType) {
        this.engineType = engineType;
    }

    public BackupJobBaseInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BackupJobBaseInfo withTags(List<ResourceTag> tags) {
        this.tags = tags;
        return this;
    }

    public BackupJobBaseInfo addTagsItem(ResourceTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ResourceTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public BackupJobBaseInfo withTags(Consumer<List<ResourceTag>> tagsSetter) {
        if (this.tags == null) {
            this.tags = new ArrayList<ResourceTag>();
        }
        tagsSetter.accept(this.tags);
        return this;
    }

    public List<ResourceTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ResourceTag> tags) {
        this.tags = tags;
    }

    public BackupJobBaseInfo withEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
        return this;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public void setEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackupJobBaseInfo that = (BackupJobBaseInfo)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.engineType, that.engineType) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.enterpriseProjectId, that.enterpriseProjectId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.engineType, this.description, this.tags, this.enterpriseProjectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackupJobBaseInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    engineType: ").append(this.toIndentedString(this.engineType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    enterpriseProjectId: ").append(this.toIndentedString(this.enterpriseProjectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EngineTypeEnum {
        public static final EngineTypeEnum SQLSERVER = new EngineTypeEnum("sqlserver");
        private static final Map<String, EngineTypeEnum> STATIC_FIELDS = EngineTypeEnum.createStaticFields();
        private String value;

        private static Map<String, EngineTypeEnum> createStaticFields() {
            HashMap<String, EngineTypeEnum> map = new HashMap<String, EngineTypeEnum>();
            map.put("sqlserver", SQLSERVER);
            return Collections.unmodifiableMap(map);
        }

        EngineTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EngineTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EngineTypeEnum(value));
        }

        public static EngineTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EngineTypeEnum) {
                return this.value.equals(((EngineTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

