/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.BackupFileInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BackupInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="file_source")
    private FileSourceEnum fileSource;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="bucket_name")
    private String bucketName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="files")
    private List<BackupFileInfo> files = null;

    public BackupInfo withFileSource(FileSourceEnum fileSource) {
        this.fileSource = fileSource;
        return this;
    }

    public FileSourceEnum getFileSource() {
        return this.fileSource;
    }

    public void setFileSource(FileSourceEnum fileSource) {
        this.fileSource = fileSource;
    }

    public BackupInfo withBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public BackupInfo withFiles(List<BackupFileInfo> files) {
        this.files = files;
        return this;
    }

    public BackupInfo addFilesItem(BackupFileInfo filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<BackupFileInfo>();
        }
        this.files.add(filesItem);
        return this;
    }

    public BackupInfo withFiles(Consumer<List<BackupFileInfo>> filesSetter) {
        if (this.files == null) {
            this.files = new ArrayList<BackupFileInfo>();
        }
        filesSetter.accept(this.files);
        return this;
    }

    public List<BackupFileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(List<BackupFileInfo> files) {
        this.files = files;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackupInfo that = (BackupInfo)obj;
        return Objects.equals(this.fileSource, that.fileSource) && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.fileSource, this.bucketName, this.files);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackupInfo {\n");
        sb.append("    fileSource: ").append(this.toIndentedString(this.fileSource)).append("\n");
        sb.append("    bucketName: ").append(this.toIndentedString(this.bucketName)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class FileSourceEnum {
        public static final FileSourceEnum OBS = new FileSourceEnum("OBS");
        public static final FileSourceEnum RDS = new FileSourceEnum("RDS");
        private static final Map<String, FileSourceEnum> STATIC_FIELDS = FileSourceEnum.createStaticFields();
        private String value;

        private static Map<String, FileSourceEnum> createStaticFields() {
            HashMap<String, FileSourceEnum> map = new HashMap<String, FileSourceEnum>();
            map.put("OBS", OBS);
            map.put("RDS", RDS);
            return Collections.unmodifiableMap(map);
        }

        FileSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileSourceEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new FileSourceEnum(value));
        }

        public static FileSourceEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileSourceEnum) {
                return this.value.equals(((FileSourceEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

