/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.drs.v5.model.ActionParams;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ActionReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="job_id")
    private String jobId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action_name")
    private ActionNameEnum actionName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action_params")
    private ActionParams actionParams;

    public ActionReq withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ActionReq withActionName(ActionNameEnum actionName) {
        this.actionName = actionName;
        return this;
    }

    public ActionNameEnum getActionName() {
        return this.actionName;
    }

    public void setActionName(ActionNameEnum actionName) {
        this.actionName = actionName;
    }

    public ActionReq withActionParams(ActionParams actionParams) {
        this.actionParams = actionParams;
        return this;
    }

    public ActionReq withActionParams(Consumer<ActionParams> actionParamsSetter) {
        if (this.actionParams == null) {
            this.actionParams = new ActionParams();
            actionParamsSetter.accept(this.actionParams);
        }
        return this;
    }

    public ActionParams getActionParams() {
        return this.actionParams;
    }

    public void setActionParams(ActionParams actionParams) {
        this.actionParams = actionParams;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActionReq that = (ActionReq)obj;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.actionName, that.actionName) && Objects.equals(this.actionParams, that.actionParams);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.actionName, this.actionParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionReq {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    actionName: ").append(this.toIndentedString(this.actionName)).append("\n");
        sb.append("    actionParams: ").append(this.toIndentedString(this.actionParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ActionNameEnum {
        public static final ActionNameEnum NETWORK = new ActionNameEnum("network");
        public static final ActionNameEnum PRECHECK = new ActionNameEnum("precheck");
        public static final ActionNameEnum START = new ActionNameEnum("start");
        public static final ActionNameEnum STOP = new ActionNameEnum("stop");
        public static final ActionNameEnum RESTART = new ActionNameEnum("restart");
        public static final ActionNameEnum RESET = new ActionNameEnum("reset");
        public static final ActionNameEnum TERMINATE = new ActionNameEnum("terminate");
        public static final ActionNameEnum SKIP_PRECHECK = new ActionNameEnum("skip_precheck");
        public static final ActionNameEnum CREATE_COMPARE = new ActionNameEnum("create_compare");
        public static final ActionNameEnum CANCEL_COMPARE = new ActionNameEnum("cancel_compare");
        public static final ActionNameEnum COLUMN_LIMIT = new ActionNameEnum("column_limit");
        public static final ActionNameEnum RELOAD_PARAMETERS = new ActionNameEnum("reload_parameters");
        public static final ActionNameEnum BIND_EIP = new ActionNameEnum("bind_eip");
        public static final ActionNameEnum UNBIND_EIP = new ActionNameEnum("unbind_eip");
        public static final ActionNameEnum SET_WRITABLE = new ActionNameEnum("set_writable");
        public static final ActionNameEnum CLOUD_CONNECTION = new ActionNameEnum("cloud_connection");
        public static final ActionNameEnum SET_READONLY = new ActionNameEnum("set_readonly");
        private static final Map<String, ActionNameEnum> STATIC_FIELDS = ActionNameEnum.createStaticFields();
        private String value;

        private static Map<String, ActionNameEnum> createStaticFields() {
            HashMap<String, ActionNameEnum> map = new HashMap<String, ActionNameEnum>();
            map.put("network", NETWORK);
            map.put("precheck", PRECHECK);
            map.put("start", START);
            map.put("stop", STOP);
            map.put("restart", RESTART);
            map.put("reset", RESET);
            map.put("terminate", TERMINATE);
            map.put("skip_precheck", SKIP_PRECHECK);
            map.put("create_compare", CREATE_COMPARE);
            map.put("cancel_compare", CANCEL_COMPARE);
            map.put("column_limit", COLUMN_LIMIT);
            map.put("reload_parameters", RELOAD_PARAMETERS);
            map.put("bind_eip", BIND_EIP);
            map.put("unbind_eip", UNBIND_EIP);
            map.put("set_writable", SET_WRITABLE);
            map.put("cloud_connection", CLOUD_CONNECTION);
            map.put("set_readonly", SET_READONLY);
            return Collections.unmodifiableMap(map);
        }

        ActionNameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionNameEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ActionNameEnum(value));
        }

        public static ActionNameEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionNameEnum) {
                return this.value.equals(((ActionNameEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

