/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.drs.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class SubscriptionInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoints")
    private List<String> endpoints = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol;

    public SubscriptionInfo withEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public SubscriptionInfo addEndpointsItem(String endpointsItem) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(endpointsItem);
        return this;
    }

    public SubscriptionInfo withEndpoints(Consumer<List<String>> endpointsSetter) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        endpointsSetter.accept(this.endpoints);
        return this;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public SubscriptionInfo withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionInfo that = (SubscriptionInfo)obj;
        return Objects.equals(this.endpoints, that.endpoints) && Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionInfo {\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ProtocolEnum {
        public static final ProtocolEnum SMS = new ProtocolEnum("sms");
        public static final ProtocolEnum EMAIL = new ProtocolEnum("email");
        private static final Map<String, ProtocolEnum> STATIC_FIELDS = ProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, ProtocolEnum> createStaticFields() {
            HashMap<String, ProtocolEnum> map = new HashMap<String, ProtocolEnum>();
            map.put("sms", SMS);
            map.put("email", EMAIL);
            return Collections.unmodifiableMap(map);
        }

        ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ProtocolEnum(value));
        }

        public static ProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProtocolEnum) {
                return this.value.equals(((ProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

