/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dataartsstudio.v1.model.AppUpdateDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class UpdateAppRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="workspace")
    private String workspace;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Dlm-Type")
    private DlmTypeEnum dlmType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_id")
    private String appId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private AppUpdateDTO body;

    public UpdateAppRequest withWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public UpdateAppRequest withDlmType(DlmTypeEnum dlmType) {
        this.dlmType = dlmType;
        return this;
    }

    public DlmTypeEnum getDlmType() {
        return this.dlmType;
    }

    public void setDlmType(DlmTypeEnum dlmType) {
        this.dlmType = dlmType;
    }

    public UpdateAppRequest withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public UpdateAppRequest withBody(AppUpdateDTO body) {
        this.body = body;
        return this;
    }

    public UpdateAppRequest withBody(Consumer<AppUpdateDTO> bodySetter) {
        if (this.body == null) {
            this.body = new AppUpdateDTO();
            bodySetter.accept(this.body);
        }
        return this;
    }

    public AppUpdateDTO getBody() {
        return this.body;
    }

    public void setBody(AppUpdateDTO body) {
        this.body = body;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateAppRequest that = (UpdateAppRequest)obj;
        return Objects.equals(this.workspace, that.workspace) && Objects.equals(this.dlmType, that.dlmType) && Objects.equals(this.appId, that.appId) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.workspace, this.dlmType, this.appId, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAppRequest {\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    dlmType: ").append(this.toIndentedString(this.dlmType)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DlmTypeEnum {
        public static final DlmTypeEnum SHARED = new DlmTypeEnum("SHARED");
        public static final DlmTypeEnum EXCLUSIVE = new DlmTypeEnum("EXCLUSIVE");
        private static final Map<String, DlmTypeEnum> STATIC_FIELDS = DlmTypeEnum.createStaticFields();
        private String value;

        private static Map<String, DlmTypeEnum> createStaticFields() {
            HashMap<String, DlmTypeEnum> map = new HashMap<String, DlmTypeEnum>();
            map.put("SHARED", SHARED);
            map.put("EXCLUSIVE", EXCLUSIVE);
            return Collections.unmodifiableMap(map);
        }

        DlmTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DlmTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DlmTypeEnum(value));
        }

        public static DlmTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DlmTypeEnum) {
                return this.value.equals(((DlmTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

