/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DependJob {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="jobs")
    private List<String> jobs = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="depend_period")
    private DependPeriodEnum dependPeriod;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="depend_fail_policy")
    private DependFailPolicyEnum dependFailPolicy;

    public DependJob withJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public DependJob addJobsItem(String jobsItem) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<String>();
        }
        this.jobs.add(jobsItem);
        return this;
    }

    public DependJob withJobs(Consumer<List<String>> jobsSetter) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<String>();
        }
        jobsSetter.accept(this.jobs);
        return this;
    }

    public List<String> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<String> jobs) {
        this.jobs = jobs;
    }

    public DependJob withDependPeriod(DependPeriodEnum dependPeriod) {
        this.dependPeriod = dependPeriod;
        return this;
    }

    public DependPeriodEnum getDependPeriod() {
        return this.dependPeriod;
    }

    public void setDependPeriod(DependPeriodEnum dependPeriod) {
        this.dependPeriod = dependPeriod;
    }

    public DependJob withDependFailPolicy(DependFailPolicyEnum dependFailPolicy) {
        this.dependFailPolicy = dependFailPolicy;
        return this;
    }

    public DependFailPolicyEnum getDependFailPolicy() {
        return this.dependFailPolicy;
    }

    public void setDependFailPolicy(DependFailPolicyEnum dependFailPolicy) {
        this.dependFailPolicy = dependFailPolicy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DependJob that = (DependJob)obj;
        return Objects.equals(this.jobs, that.jobs) && Objects.equals(this.dependPeriod, that.dependPeriod) && Objects.equals(this.dependFailPolicy, that.dependFailPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.dependPeriod, this.dependFailPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DependJob {\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("    dependPeriod: ").append(this.toIndentedString(this.dependPeriod)).append("\n");
        sb.append("    dependFailPolicy: ").append(this.toIndentedString(this.dependFailPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DependFailPolicyEnum {
        public static final DependFailPolicyEnum FAIL = new DependFailPolicyEnum("FAIL");
        public static final DependFailPolicyEnum IGNORE = new DependFailPolicyEnum("IGNORE");
        public static final DependFailPolicyEnum SUSPEND = new DependFailPolicyEnum("SUSPEND");
        private static final Map<String, DependFailPolicyEnum> STATIC_FIELDS = DependFailPolicyEnum.createStaticFields();
        private String value;

        private static Map<String, DependFailPolicyEnum> createStaticFields() {
            HashMap<String, DependFailPolicyEnum> map = new HashMap<String, DependFailPolicyEnum>();
            map.put("FAIL", FAIL);
            map.put("IGNORE", IGNORE);
            map.put("SUSPEND", SUSPEND);
            return Collections.unmodifiableMap(map);
        }

        DependFailPolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DependFailPolicyEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DependFailPolicyEnum(value));
        }

        public static DependFailPolicyEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DependFailPolicyEnum) {
                return this.value.equals(((DependFailPolicyEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class DependPeriodEnum {
        public static final DependPeriodEnum SAME_PERIOD = new DependPeriodEnum("SAME_PERIOD");
        public static final DependPeriodEnum PRE_PERIOD = new DependPeriodEnum("PRE_PERIOD");
        private static final Map<String, DependPeriodEnum> STATIC_FIELDS = DependPeriodEnum.createStaticFields();
        private String value;

        private static Map<String, DependPeriodEnum> createStaticFields() {
            HashMap<String, DependPeriodEnum> map = new HashMap<String, DependPeriodEnum>();
            map.put("SAME_PERIOD", SAME_PERIOD);
            map.put("PRE_PERIOD", PRE_PERIOD);
            return Collections.unmodifiableMap(map);
        }

        DependPeriodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DependPeriodEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DependPeriodEnum(value));
        }

        public static DependPeriodEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DependPeriodEnum) {
                return this.value.equals(((DependPeriodEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

