/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DataMapFilterCriteria {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="attribute")
    private AttributeEnum attribute;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="operator")
    private OperatorEnum operator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private List<String> value = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="condition")
    private ConditionEnum condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="criterion")
    private List<DataMapFilterCriteria> criterion = null;

    public DataMapFilterCriteria withAttribute(AttributeEnum attribute) {
        this.attribute = attribute;
        return this;
    }

    public AttributeEnum getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeEnum attribute) {
        this.attribute = attribute;
    }

    public DataMapFilterCriteria withOperator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public DataMapFilterCriteria withValue(List<String> value) {
        this.value = value;
        return this;
    }

    public DataMapFilterCriteria addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    public DataMapFilterCriteria withValue(Consumer<List<String>> valueSetter) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        valueSetter.accept(this.value);
        return this;
    }

    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public DataMapFilterCriteria withCondition(ConditionEnum condition) {
        this.condition = condition;
        return this;
    }

    public ConditionEnum getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionEnum condition) {
        this.condition = condition;
    }

    public DataMapFilterCriteria withCriterion(List<DataMapFilterCriteria> criterion) {
        this.criterion = criterion;
        return this;
    }

    public DataMapFilterCriteria addCriterionItem(DataMapFilterCriteria criterionItem) {
        if (this.criterion == null) {
            this.criterion = new ArrayList<DataMapFilterCriteria>();
        }
        this.criterion.add(criterionItem);
        return this;
    }

    public DataMapFilterCriteria withCriterion(Consumer<List<DataMapFilterCriteria>> criterionSetter) {
        if (this.criterion == null) {
            this.criterion = new ArrayList<DataMapFilterCriteria>();
        }
        criterionSetter.accept(this.criterion);
        return this;
    }

    public List<DataMapFilterCriteria> getCriterion() {
        return this.criterion;
    }

    public void setCriterion(List<DataMapFilterCriteria> criterion) {
        this.criterion = criterion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataMapFilterCriteria that = (DataMapFilterCriteria)obj;
        return Objects.equals(this.attribute, that.attribute) && Objects.equals(this.operator, that.operator) && Objects.equals(this.value, that.value) && Objects.equals(this.condition, that.condition) && Objects.equals(this.criterion, that.criterion);
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.operator, this.value, this.condition, this.criterion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataMapFilterCriteria {\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    criterion: ").append(this.toIndentedString(this.criterion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ConditionEnum {
        public static final ConditionEnum OR = new ConditionEnum("OR");
        private static final Map<String, ConditionEnum> STATIC_FIELDS = ConditionEnum.createStaticFields();
        private String value;

        private static Map<String, ConditionEnum> createStaticFields() {
            HashMap<String, ConditionEnum> map = new HashMap<String, ConditionEnum>();
            map.put("OR", OR);
            return Collections.unmodifiableMap(map);
        }

        ConditionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConditionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ConditionEnum(value));
        }

        public static ConditionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConditionEnum) {
                return this.value.equals(((ConditionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class OperatorEnum {
        public static final OperatorEnum IN = new OperatorEnum("IN");
        public static final OperatorEnum EQ = new OperatorEnum("EQ");
        private static final Map<String, OperatorEnum> STATIC_FIELDS = OperatorEnum.createStaticFields();
        private String value;

        private static Map<String, OperatorEnum> createStaticFields() {
            HashMap<String, OperatorEnum> map = new HashMap<String, OperatorEnum>();
            map.put("IN", IN);
            map.put("EQ", EQ);
            return Collections.unmodifiableMap(map);
        }

        OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OperatorEnum(value));
        }

        public static OperatorEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OperatorEnum) {
                return this.value.equals(((OperatorEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class AttributeEnum {
        public static final AttributeEnum BASE_DATAASSET_SOURCETYPE = new AttributeEnum("base.DataAsset.sourceType");
        public static final AttributeEnum TYPENAME = new AttributeEnum("typeName");
        public static final AttributeEnum CLASSIFICATIONS_NAME = new AttributeEnum("classifications.name");
        public static final AttributeEnum TAGS_NAME = new AttributeEnum("tags.name");
        public static final AttributeEnum SECURITYLEVEL_NAME = new AttributeEnum("securityLevel.name");
        public static final AttributeEnum WORKSPACEID = new AttributeEnum("workspaceId");
        private static final Map<String, AttributeEnum> STATIC_FIELDS = AttributeEnum.createStaticFields();
        private String value;

        private static Map<String, AttributeEnum> createStaticFields() {
            HashMap<String, AttributeEnum> map = new HashMap<String, AttributeEnum>();
            map.put("base.DataAsset.sourceType", BASE_DATAASSET_SOURCETYPE);
            map.put("typeName", TYPENAME);
            map.put("classifications.name", CLASSIFICATIONS_NAME);
            map.put("tags.name", TAGS_NAME);
            map.put("securityLevel.name", SECURITYLEVEL_NAME);
            map.put("workspaceId", WORKSPACEID);
            return Collections.unmodifiableMap(map);
        }

        AttributeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttributeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AttributeEnum(value));
        }

        public static AttributeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttributeEnum) {
                return this.value.equals(((AttributeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

