/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dataartsstudio.v1.model.CustomizedFieldsVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CustomizedFieldsVOList {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="fields")
    private List<CustomizedFieldsVO> fields = null;

    public CustomizedFieldsVOList withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CustomizedFieldsVOList withFields(List<CustomizedFieldsVO> fields) {
        this.fields = fields;
        return this;
    }

    public CustomizedFieldsVOList addFieldsItem(CustomizedFieldsVO fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<CustomizedFieldsVO>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    public CustomizedFieldsVOList withFields(Consumer<List<CustomizedFieldsVO>> fieldsSetter) {
        if (this.fields == null) {
            this.fields = new ArrayList<CustomizedFieldsVO>();
        }
        fieldsSetter.accept(this.fields);
        return this;
    }

    public List<CustomizedFieldsVO> getFields() {
        return this.fields;
    }

    public void setFields(List<CustomizedFieldsVO> fields) {
        this.fields = fields;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CustomizedFieldsVOList that = (CustomizedFieldsVOList)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomizedFieldsVOList {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum TABLE = new TypeEnum("TABLE");
        public static final TypeEnum ATTRIBUTE = new TypeEnum("ATTRIBUTE");
        public static final TypeEnum SUBJECT = new TypeEnum("SUBJECT");
        public static final TypeEnum METRIC = new TypeEnum("METRIC");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("TABLE", TABLE);
            map.put("ATTRIBUTE", ATTRIBUTE);
            map.put("SUBJECT", SUBJECT);
            map.put("METRIC", METRIC);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

