/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dataartsstudio.v1.model.CatalogMetaDataEventInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CatalogMetaDataEventRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="engine")
    private EngineEnum engine;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="engine_version")
    private String engineVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="events")
    private List<CatalogMetaDataEventInfo> events = null;

    public CatalogMetaDataEventRequest withEngine(EngineEnum engine) {
        this.engine = engine;
        return this;
    }

    public EngineEnum getEngine() {
        return this.engine;
    }

    public void setEngine(EngineEnum engine) {
        this.engine = engine;
    }

    public CatalogMetaDataEventRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CatalogMetaDataEventRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public CatalogMetaDataEventRequest withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public CatalogMetaDataEventRequest withEvents(List<CatalogMetaDataEventInfo> events) {
        this.events = events;
        return this;
    }

    public CatalogMetaDataEventRequest addEventsItem(CatalogMetaDataEventInfo eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<CatalogMetaDataEventInfo>();
        }
        this.events.add(eventsItem);
        return this;
    }

    public CatalogMetaDataEventRequest withEvents(Consumer<List<CatalogMetaDataEventInfo>> eventsSetter) {
        if (this.events == null) {
            this.events = new ArrayList<CatalogMetaDataEventInfo>();
        }
        eventsSetter.accept(this.events);
        return this;
    }

    public List<CatalogMetaDataEventInfo> getEvents() {
        return this.events;
    }

    public void setEvents(List<CatalogMetaDataEventInfo> events) {
        this.events = events;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogMetaDataEventRequest that = (CatalogMetaDataEventRequest)obj;
        return Objects.equals(this.engine, that.engine) && Objects.equals(this.engineVersion, that.engineVersion) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.events, that.events);
    }

    public int hashCode() {
        return Objects.hash(this.engine, this.engineVersion, this.instanceId, this.projectId, this.events);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogMetaDataEventRequest {\n");
        sb.append("    engine: ").append(this.toIndentedString(this.engine)).append("\n");
        sb.append("    engineVersion: ").append(this.toIndentedString(this.engineVersion)).append("\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EngineEnum {
        public static final EngineEnum DLI = new EngineEnum("DLI");
        public static final EngineEnum MRS = new EngineEnum("MRS");
        public static final EngineEnum DWS = new EngineEnum("DWS");
        private static final Map<String, EngineEnum> STATIC_FIELDS = EngineEnum.createStaticFields();
        private String value;

        private static Map<String, EngineEnum> createStaticFields() {
            HashMap<String, EngineEnum> map = new HashMap<String, EngineEnum>();
            map.put("DLI", DLI);
            map.put("MRS", MRS);
            map.put("DWS", DWS);
            return Collections.unmodifiableMap(map);
        }

        EngineEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EngineEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EngineEnum(value));
        }

        public static EngineEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EngineEnum) {
                return this.value.equals(((EngineEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

