/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsstudio.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dataartsstudio.v1.model.BackendConstant;
import com.huaweicloud.sdk.dataartsstudio.v1.model.BackendRequestPara;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BackendConfig {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="host")
    private String host;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="timeout")
    private Integer timeout;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="path")
    private String path;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="backend_paras")
    private List<BackendRequestPara> backendParas = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="constant_paras")
    private List<BackendConstant> constantParas = null;

    public BackendConfig withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BackendConfig withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public BackendConfig withHost(String host) {
        this.host = host;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public BackendConfig withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public BackendConfig withPath(String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BackendConfig withBackendParas(List<BackendRequestPara> backendParas) {
        this.backendParas = backendParas;
        return this;
    }

    public BackendConfig addBackendParasItem(BackendRequestPara backendParasItem) {
        if (this.backendParas == null) {
            this.backendParas = new ArrayList<BackendRequestPara>();
        }
        this.backendParas.add(backendParasItem);
        return this;
    }

    public BackendConfig withBackendParas(Consumer<List<BackendRequestPara>> backendParasSetter) {
        if (this.backendParas == null) {
            this.backendParas = new ArrayList<BackendRequestPara>();
        }
        backendParasSetter.accept(this.backendParas);
        return this;
    }

    public List<BackendRequestPara> getBackendParas() {
        return this.backendParas;
    }

    public void setBackendParas(List<BackendRequestPara> backendParas) {
        this.backendParas = backendParas;
    }

    public BackendConfig withConstantParas(List<BackendConstant> constantParas) {
        this.constantParas = constantParas;
        return this;
    }

    public BackendConfig addConstantParasItem(BackendConstant constantParasItem) {
        if (this.constantParas == null) {
            this.constantParas = new ArrayList<BackendConstant>();
        }
        this.constantParas.add(constantParasItem);
        return this;
    }

    public BackendConfig withConstantParas(Consumer<List<BackendConstant>> constantParasSetter) {
        if (this.constantParas == null) {
            this.constantParas = new ArrayList<BackendConstant>();
        }
        constantParasSetter.accept(this.constantParas);
        return this;
    }

    public List<BackendConstant> getConstantParas() {
        return this.constantParas;
    }

    public void setConstantParas(List<BackendConstant> constantParas) {
        this.constantParas = constantParas;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BackendConfig that = (BackendConfig)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.host, that.host) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.path, that.path) && Objects.equals(this.backendParas, that.backendParas) && Objects.equals(this.constantParas, that.constantParas);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.protocol, this.host, this.timeout, this.path, this.backendParas, this.constantParas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackendConfig {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    backendParas: ").append(this.toIndentedString(this.backendParas)).append("\n");
        sb.append("    constantParas: ").append(this.toIndentedString(this.constantParas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ProtocolEnum {
        public static final ProtocolEnum PROTOCOL_TYPE_HTTP = new ProtocolEnum("PROTOCOL_TYPE_HTTP");
        public static final ProtocolEnum PROTOCOL_TYPE_HTTPS = new ProtocolEnum("PROTOCOL_TYPE_HTTPS");
        private static final Map<String, ProtocolEnum> STATIC_FIELDS = ProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, ProtocolEnum> createStaticFields() {
            HashMap<String, ProtocolEnum> map = new HashMap<String, ProtocolEnum>();
            map.put("PROTOCOL_TYPE_HTTP", PROTOCOL_TYPE_HTTP);
            map.put("PROTOCOL_TYPE_HTTPS", PROTOCOL_TYPE_HTTPS);
            return Collections.unmodifiableMap(map);
        }

        ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ProtocolEnum(value));
        }

        public static ProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProtocolEnum) {
                return this.value.equals(((ProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class TypeEnum {
        public static final TypeEnum REQUEST_TYPE_POST = new TypeEnum("REQUEST_TYPE_POST");
        public static final TypeEnum REQUEST_TYPE_GET = new TypeEnum("REQUEST_TYPE_GET");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("REQUEST_TYPE_POST", REQUEST_TYPE_POST);
            map.put("REQUEST_TYPE_GET", REQUEST_TYPE_GET);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

