/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dataartsfabric.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AgencyPolicy {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="policy_type")
    private PolicyTypeEnum policyType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_required")
    private Boolean isRequired;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_enable")
    private Boolean isEnable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="actions")
    private List<String> actions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;

    public AgencyPolicy withPolicyType(PolicyTypeEnum policyType) {
        this.policyType = policyType;
        return this;
    }

    public PolicyTypeEnum getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(PolicyTypeEnum policyType) {
        this.policyType = policyType;
    }

    public AgencyPolicy withIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public AgencyPolicy withIsEnable(Boolean isEnable) {
        this.isEnable = isEnable;
        return this;
    }

    public Boolean getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(Boolean isEnable) {
        this.isEnable = isEnable;
    }

    public AgencyPolicy withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public AgencyPolicy addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    public AgencyPolicy withActions(Consumer<List<String>> actionsSetter) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        actionsSetter.accept(this.actions);
        return this;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public AgencyPolicy withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AgencyPolicy that = (AgencyPolicy)obj;
        return Objects.equals(this.policyType, that.policyType) && Objects.equals(this.isRequired, that.isRequired) && Objects.equals(this.isEnable, that.isEnable) && Objects.equals(this.actions, that.actions) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.policyType, this.isRequired, this.isEnable, this.actions, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgencyPolicy {\n");
        sb.append("    policyType: ").append(this.toIndentedString(this.policyType)).append("\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("    isEnable: ").append(this.toIndentedString(this.isEnable)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class PolicyTypeEnum {
        public static final PolicyTypeEnum FABRIC_COMMON_POLICY = new PolicyTypeEnum("FABRIC_COMMON_POLICY");
        public static final PolicyTypeEnum FABRIC_SMN_POLICY = new PolicyTypeEnum("FABRIC_SMN_POLICY");
        public static final PolicyTypeEnum FABRIC_LAKEFORMATION_POLICY = new PolicyTypeEnum("FABRIC_LAKEFORMATION_POLICY");
        public static final PolicyTypeEnum FABRIC_AOM_POLICY = new PolicyTypeEnum("FABRIC_AOM_POLICY");
        private static final Map<String, PolicyTypeEnum> STATIC_FIELDS = PolicyTypeEnum.createStaticFields();
        private String value;

        private static Map<String, PolicyTypeEnum> createStaticFields() {
            HashMap<String, PolicyTypeEnum> map = new HashMap<String, PolicyTypeEnum>();
            map.put("FABRIC_COMMON_POLICY", FABRIC_COMMON_POLICY);
            map.put("FABRIC_SMN_POLICY", FABRIC_SMN_POLICY);
            map.put("FABRIC_LAKEFORMATION_POLICY", FABRIC_LAKEFORMATION_POLICY);
            map.put("FABRIC_AOM_POLICY", FABRIC_AOM_POLICY);
            return Collections.unmodifiableMap(map);
        }

        PolicyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PolicyTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new PolicyTypeEnum(value));
        }

        public static PolicyTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof PolicyTypeEnum) {
                return this.value.equals(((PolicyTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

