/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.FormDataFilePart;
import com.huaweicloud.sdk.core.json.FormDataDeserializer;
import com.huaweicloud.sdk.core.json.OffsetDateTimeDeserializer;
import com.huaweicloud.sdk.core.json.StrictBooleanDeserializer;
import com.huaweicloud.sdk.core.json.StrictDoubleDeserializer;
import com.huaweicloud.sdk.core.json.StrictFloatDeserializer;
import com.huaweicloud.sdk.core.json.StrictIntegerDeserializer;
import com.huaweicloud.sdk.core.json.StrictLongDeserializer;
import com.huaweicloud.sdk.core.json.StrictStringDeserializer;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper objectMapperIgnoreUnknown = JsonUtils.initializeBaseMapper();

    private JsonUtils() {
    }

    private static ObjectMapper initializeBaseMapper() {
        SerializationConfig writeConfig;
        DeserializationConfig readConfig;
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new SimpleModule().addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Boolean.class, (JsonDeserializer)new StrictBooleanDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Integer.class, (JsonDeserializer)new StrictIntegerDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Long.class, (JsonDeserializer)new StrictLongDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Double.class, (JsonDeserializer)new StrictDoubleDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Float.class, (JsonDeserializer)new StrictFloatDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(String.class, (JsonDeserializer)new StrictStringDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(FormDataFilePart.class, (JsonDeserializer)new FormDataDeserializer())).setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        try {
            readConfig = mapper.getDeserializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS);
            writeConfig = mapper.getSerializationConfig().with((FormatFeature)JsonWriteFeature.ESCAPE_NON_ASCII);
        }
        catch (NoClassDefFoundError ignore) {
            readConfig = mapper.getDeserializationConfig().with(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
            writeConfig = mapper.getSerializationConfig().with(JsonGenerator.Feature.ESCAPE_NON_ASCII);
            logger.warn("Cannot find class definitions for JsonReadFeature and JsonWriteFeature due to version conflict, use deprecated JsonParser and JsonGenerator instead. It is recommended that you use v2.10+(currently in use: {}) for better security and compatibility.", (Object)mapper.version().toFullString());
        }
        return mapper.setConfig(readConfig).setConfig(writeConfig);
    }

    public static ObjectMapper getDefaultMapper() {
        return objectMapperIgnoreUnknown;
    }

    public static String toJSON(Object object) {
        try {
            return objectMapperIgnoreUnknown.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSON] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static String toJSON(ObjectMapper mapper, Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSON] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static String toJSON(String mapperFilterName, Object resultMapper, Set<String> exceptProperties) {
        try {
            if (exceptProperties == null) {
                return objectMapperIgnoreUnknown.writeValueAsString(resultMapper);
            }
            SimpleBeanPropertyFilter simpleBeanPropertyFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])exceptProperties.toArray(new String[exceptProperties.size()]));
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(mapperFilterName, simpleBeanPropertyFilter);
            return objectMapperIgnoreUnknown.writer((FilterProvider)filterProvider).writeValueAsString(resultMapper);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSON] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> type) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, type));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> Map<String, T> toMapObject(String json, Class<T> clazz) {
        try {
            return StringUtils.isEmpty(json) ? null : (Map)objectMapperIgnoreUnknown.readValue(json, (JavaType)objectMapperIgnoreUnknown.getTypeFactory().constructMapType(Map.class, String.class, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toListObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static Map<String, Object> objectToMap(Object o) {
        return JsonUtils.objectToMap(objectMapperIgnoreUnknown, o);
    }

    public static Map<String, Object> objectToMap(ObjectMapper mapper, Object o) {
        Objects.requireNonNull(o, "input of objectToMap cannot be null");
        try {
            return (Map)mapper.readValue(mapper.writeValueAsString(o), (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method objectToMap] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> List<T> toListObject(String json, Class<T> clazz) {
        try {
            return StringUtils.isEmpty(json) ? null : (List)objectMapperIgnoreUnknown.readValue(json, objectMapperIgnoreUnknown.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toListObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectIgnoreUnknown(String json, Class<T> clazz) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectIgnoreUnknown(String json, TypeReference<T> type) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, type));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectByStrict(String json, Class<T> clazz) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectByStrict(String json, TypeReference<T> type) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, type));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectIgnoreUnknownByStrict(String json, Class<T> clazz) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObjectIgnoreUnknownByStrict(String json, TypeReference<T> type) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : objectMapperIgnoreUnknown.readValue(json, type));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> List<T> toListObjectIgnoreUnknownByStrict(String json, Class<T> clazz) {
        try {
            return StringUtils.isEmpty(json) ? null : (List)objectMapperIgnoreUnknown.readValue(json, objectMapperIgnoreUnknown.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toListObjectIgnoreUnknownByStrict] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static Map<String, Map<String, Object>> toStrMapToStrObjMap(String json) {
        return JsonUtils.toObjectIgnoreUnknown(json, new TypeReference<Map<String, Map<String, Object>>>(){});
    }

    public static byte[] toJSONAsBytes(Object resultMapper) {
        try {
            return objectMapperIgnoreUnknown.writeValueAsBytes(resultMapper);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSONAsBytes] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static byte[] toJSONAsBytes(String mapperFilterName, Object resultMapper, Set<String> exceptProperties) {
        try {
            if (exceptProperties == null) {
                return objectMapperIgnoreUnknown.writeValueAsBytes(resultMapper);
            }
            SimpleBeanPropertyFilter simpleBeanPropertyFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])exceptProperties.toArray(new String[exceptProperties.size()]));
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(mapperFilterName, simpleBeanPropertyFilter);
            return objectMapperIgnoreUnknown.writer((FilterProvider)filterProvider).writeValueAsBytes(resultMapper);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSONAsBytes] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T fromStream(InputStream is, Class<T> clazz) {
        try {
            return (T)objectMapperIgnoreUnknown.readValue(is, clazz);
        }
        catch (IOException e) {
            logger.error("[Method fromStream] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T fromStream(InputStream is, TypeReference<T> type) {
        try {
            return (T)objectMapperIgnoreUnknown.readValue(is, type);
        }
        catch (IOException e) {
            logger.error("[Method fromStream] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }
}

