/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public final class HttpUtils {
    private static final List<String> TEXT_BASED_CONTENT_TYPES = Arrays.asList("application/json", "application/xml", "text");
    private static final List<String> OCTET_STREAM_CONTENT_TYPES = Arrays.asList("application/octet-stream", "binary/octet-stream");
    private static final List<String> FILE_STREAM_CONTENT_TYPES = Arrays.asList("application/octet-stream", "binary/octet-stream", "application/zip");

    private HttpUtils() {
    }

    public static boolean isTextBasedContentType(String contentType) {
        if (!StringUtils.isEmpty(contentType)) {
            for (String textBasedContentType : TEXT_BASED_CONTENT_TYPES) {
                if (!contentType.startsWith(textBasedContentType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOctetStreamContentType(String contentType) {
        if (!StringUtils.isEmpty(contentType)) {
            for (String octetStreamContentType : OCTET_STREAM_CONTENT_TYPES) {
                if (!contentType.startsWith(octetStreamContentType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFileStreamContentType(String contentType) {
        if (!StringUtils.isEmpty(contentType)) {
            for (String fileStreamContentType : FILE_STREAM_CONTENT_TYPES) {
                if (!contentType.startsWith(fileStreamContentType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBsonContentType(String contentType) {
        return "application/bson".equals(contentType);
    }
}

