/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.auth.ICredentialProvider;
import com.huaweicloud.sdk.core.auth.MetadataAccessor;
import com.huaweicloud.sdk.core.auth.MetadataBasicCredentialProvider;
import com.huaweicloud.sdk.core.auth.MetadataGlobalCredentialProvider;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Locale;

public class MetadataCredentialProvider
implements ICredentialProvider {
    private final String credentialType;
    private Long expirationThresholdSeconds;

    public MetadataCredentialProvider(String credentialType) {
        this.credentialType = credentialType.toLowerCase(Locale.US);
    }

    public static MetadataBasicCredentialProvider getBasicCredentialMetadataProvider() {
        return new MetadataBasicCredentialProvider();
    }

    public static MetadataGlobalCredentialProvider getGlobalCredentialMetadataProvider() {
        return new MetadataGlobalCredentialProvider();
    }

    public Long getExpirationThresholdSeconds() {
        return this.expirationThresholdSeconds;
    }

    public void setExpirationThresholdSeconds(Long expirationThresholdSeconds) {
        this.expirationThresholdSeconds = expirationThresholdSeconds;
    }

    @Override
    public ICredential getCredentials() {
        if (StringUtils.isEmpty(this.credentialType)) {
            throw new SdkException("credential type is empty");
        }
        ICredential credential = null;
        if (this.credentialType.startsWith("basic")) {
            credential = MetadataCredentialProvider.getBasicCredentialMetadataProvider().getCredentials();
        } else if (this.credentialType.startsWith("global")) {
            credential = MetadataCredentialProvider.getGlobalCredentialMetadataProvider().getCredentials();
        }
        if (credential == null) {
            throw new SdkException("unsupported credential type: " + this.credentialType);
        }
        return credential instanceof AbstractCredentials ? this.process((AbstractCredentials)credential) : credential;
    }

    protected ICredential process(AbstractCredentials<?> credentials) {
        credentials.metadataAccessor = new MetadataAccessor();
        if (this.getExpirationThresholdSeconds() != null) {
            credentials.setExpirationThresholdSeconds(this.getExpirationThresholdSeconds());
        }
        credentials.updateSecurityTokenFromMetadata();
        return credentials;
    }
}

