/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.exception.ClientRequestException;
import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import com.huaweicloud.sdk.core.internal.model.CreateTemporaryAccessKeyInEcsResponse;
import com.huaweicloud.sdk.core.internal.model.Credential;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MetadataAccessor {
    private static final String METADATA_ENDPOINT = "http://169.254.169.254";
    private static final String GET_TOKEN_PATH = "/meta-data/latest/api/token";
    private static final String GET_SECURITY_KEY_PATH = "/openstack/latest/securitykey";
    private static final String X_METADATA_TOKEN = "X-Metadata-Token";
    private static final String X_METADATA_TOKEN_TTL_SECONDS = "X-Metadata-Token-Ttl-Seconds";
    private static final String CONFIG_AGENCY_ERROR = "Please configure Cloud Service Agency first";
    private static final long DEFAULT_TOKEN_TTL_SECONDS = 21600L;
    private static final long DEFAULT_CHECK_TOKEN_DURATION_SECONDS = 86400L;
    private Long lastCallMillis;
    private String token;

    private SimpleResponse getToken() {
        Request request = new Request.Builder().url("http://169.254.169.254/meta-data/latest/api/token").addHeader(X_METADATA_TOKEN_TTL_SECONDS, String.valueOf(21600L)).put(RequestBody.create((byte[])new byte[0])).build();
        return MetadataAccessor.execute(request);
    }

    private void tryUpdateToken(boolean throwOnFailure) {
        this.lastCallMillis = System.currentTimeMillis();
        SimpleResponse response = this.getToken();
        if (response.code == 200) {
            this.token = response.body;
        } else if (response.code == 404 || response.code == 405) {
            if (throwOnFailure) {
                throw new ClientRequestException(response.code, new SdkErrorMessage(String.valueOf(response.code), response.body));
            }
            this.token = null;
        } else {
            throw new ServerResponseException(response.code, new SdkErrorMessage(String.valueOf(response.code), response.body));
        }
    }

    protected Credential getCredentials() {
        if (this.token == null && (this.lastCallMillis == null || System.currentTimeMillis() - this.lastCallMillis > 86400000L)) {
            this.tryUpdateToken(false);
        }
        Request.Builder builder = new Request.Builder().url("http://169.254.169.254/openstack/latest/securitykey").get();
        if (this.token != null) {
            builder.addHeader(X_METADATA_TOKEN, this.token);
        }
        SimpleResponse response = MetadataAccessor.execute(builder.build());
        if (response.code == 401 && !response.body.contains(CONFIG_AGENCY_ERROR)) {
            this.tryUpdateToken(true);
            Request request = new Request.Builder().url("http://169.254.169.254/openstack/latest/securitykey").addHeader(X_METADATA_TOKEN, this.token).get().build();
            response = MetadataAccessor.execute(request);
        }
        if (response.code >= 400) {
            throw new ClientRequestException(response.code, new SdkErrorMessage(String.valueOf(response.code), response.body));
        }
        CreateTemporaryAccessKeyInEcsResponse resp = JsonUtils.toObject(response.body, CreateTemporaryAccessKeyInEcsResponse.class);
        if (Objects.isNull(resp) || Objects.isNull(resp.getCredential())) {
            throw new SdkException("failed to get credentials in metadata");
        }
        return resp.getCredential();
    }

    private static SimpleResponse execute(Request request) {
        try {
            Response response = MetadataAccessor.getClient().newCall(request).execute();
            SimpleResponse simpleResponse = new SimpleResponse();
            simpleResponse.code = response.code();
            simpleResponse.body = response.body() == null ? null : response.body().string();
            return simpleResponse;
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
    }

    private static OkHttpClient getClient() {
        return ClientHolder.INSTANCE;
    }

    private static class ClientHolder {
        static final OkHttpClient INSTANCE = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).build();

        private ClientHolder() {
        }
    }

    private static class SimpleResponse {
        String body;
        int code;

        private SimpleResponse() {
        }
    }
}

