/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DerivedAKSKSigner
extends AKSKSigner {
    private static final String V_11_HMAC_SHA_256 = "V11-HMAC-SHA256";
    private static final DerivedAKSKSigner SINGLETON = new DerivedAKSKSigner();

    protected DerivedAKSKSigner() {
    }

    public static DerivedAKSKSigner getInstance() {
        return SINGLETON;
    }

    @Override
    protected <T extends AbstractCredentials<T>> void checkRequired(T credential) {
        super.checkRequired(credential);
        if (StringUtils.isEmpty(credential.regionId)) {
            throw new SdkException("regionId is required in credentials when using derived auth");
        }
        if (StringUtils.isEmpty(credential.derivedAuthServiceName)) {
            throw new SdkException("derivedAuthServiceName is required in credentials when using derived auth");
        }
    }

    @Override
    public <T extends AbstractCredentials<T>> Map<String, String> sign(HttpRequest request, T credentials) {
        this.checkRequired(credentials);
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        URL url = request.getUrl();
        String canonicalHost = request.haveHeader("Host") != false ? request.getHeader("Host") : url.getAuthority();
        authenticationHeaders.put("Host", canonicalHost);
        String dateTimeStamp = this.extractTimeStamp(request, authenticationHeaders);
        Map<String, String> allHeaders = this.combineAllHeaders(request, authenticationHeaders);
        String canonicalUri = this.buildCanonicalUri(url);
        String query = url.getQuery();
        Map<String, List<String>> parameters = request.getQueryParams();
        String canonicalQueryString = this.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = String.join((CharSequence)";", allHeaders.keySet());
        String canonicalHeaders = this.buildCanonicalHeaders(allHeaders);
        String payloadHash = this.buildPayloadHash(request);
        String canonicalRequest = this.buildCanonicalRequest(request.getMethod().name(), canonicalUri, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = BinaryUtils.toHex(this.hasher.hash(canonicalRequest.getBytes(StandardCharsets.UTF_8)));
        String dateStr = dateTimeStamp.substring(0, 8);
        String info = String.format(Locale.US, "%s/%s/%s", dateStr, credentials.regionId, credentials.derivedAuthServiceName);
        String stringToSign = this.buildStringToSign(V_11_HMAC_SHA_256, dateTimeStamp, info, canonicalRequestHash);
        String derivationKey = HKDF.getDerKeySHA256(credentials.getAk(), credentials.getSk(), info);
        AKSKSigner.HmacSigningKey hmacSigningKey = new AKSKSigner.HmacSigningKey(this.hasher, derivationKey.getBytes(StandardCharsets.UTF_8));
        String signature = this.buildSignature(stringToSign, hmacSigningKey);
        String authorization = String.format(Locale.US, "%s Credential=%s/%s, SignedHeaders=%s, Signature=%s", V_11_HMAC_SHA_256, credentials.getAk(), info, signedHeaderNames, signature);
        authenticationHeaders.put("Authorization", authorization);
        return authenticationHeaders;
    }

    static class HKDF {
        private static final String HMAC_SHA1 = "hmacsha1";
        private static final String HMAC_SHA256 = "hmacsha256";
        private static final int DERIVATION_KEY_LENGTH = 32;
        private static final String HMAC_ALGORITHM = "hmacsha256";
        private static final int ALGORITHM_HASH_LENGTH = HKDF.getHashLen("hmacsha256");
        private static final Charset UTF_8 = StandardCharsets.UTF_8;
        private static final int EXPAND_CEIL = (int)Math.ceil(32.0 / (double)ALGORITHM_HASH_LENGTH);

        HKDF() {
        }

        public static String getDerKeySHA256(String accessKey, String secretKey, String info) {
            if (null == accessKey || "".equals(accessKey) || null == secretKey || "".equals(secretKey)) {
                return null;
            }
            try {
                byte[] tmpKey = HKDF.extract(secretKey.getBytes(UTF_8), accessKey.getBytes(UTF_8), "hmacsha256");
                byte[] derSecretKey = HKDF.expand(tmpKey, info.getBytes(UTF_8), "hmacsha256", 32, EXPAND_CEIL);
                return HKDF.toHex(derSecretKey);
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                String msg = "Failed to derive AK " + accessKey + " with info " + info + " .";
                throw new SdkException(msg, e);
            }
        }

        public static String toHex(byte[] data) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            for (byte itemByte : data) {
                String hex = Integer.toHexString(itemByte);
                if (hex.length() == 1) {
                    sb.append("0");
                } else if (hex.length() == 8) {
                    hex = hex.substring(6);
                }
                sb.append(hex);
            }
            return sb.toString().toLowerCase(Locale.US);
        }

        private static byte[] extract(byte[] ikm, byte[] salt, String hmacAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
            if (salt == null || salt.length == 0) {
                salt = new byte[HKDF.getHashLen(hmacAlgorithm)];
            }
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(new SecretKeySpec(salt, hmacAlgorithm));
            return mac.doFinal(ikm);
        }

        private static byte[] expand(byte[] prk, byte[] info, String hmacAlgorithm, int okmLength, int ceil) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
            byte[] rawResult;
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(new SecretKeySpec(prk, hmacAlgorithm));
            if (ceil == 1) {
                rawResult = HKDF.expandFirst(info, mac);
            } else {
                rawResult = new byte[]{};
                byte[] temp = new byte[]{};
                for (int i = 1; i <= ceil; ++i) {
                    temp = HKDF.expandOnce(info, mac, temp, i);
                    try (ByteArrayOutputStream combineBytes = new ByteArrayOutputStream();){
                        combineBytes.write(rawResult);
                        combineBytes.write(temp);
                        rawResult = combineBytes.toByteArray();
                        continue;
                    }
                }
            }
            if (32 == rawResult.length) {
                return rawResult;
            }
            if (32 < rawResult.length) {
                return Arrays.copyOf(rawResult, 32);
            }
            throw new IOException("Failed to expand with algorithm " + hmacAlgorithm);
        }

        private static byte[] expandFirst(byte[] info, Mac mac) {
            byte[] result = new byte[info.length + 1];
            System.arraycopy(info, 0, result, 0, info.length);
            result[info.length] = 1;
            return mac.doFinal(result);
        }

        private static byte[] expandOnce(byte[] info, Mac mac, byte[] preTemp, int i) throws IOException {
            try (ByteArrayOutputStream hashBytes = new ByteArrayOutputStream();){
                hashBytes.write(preTemp);
                hashBytes.write(info);
                hashBytes.write(i);
                byte[] byArray = mac.doFinal(hashBytes.toByteArray());
                return byArray;
            }
        }

        private static int getHashLen(String hmacAlgorithm) {
            switch (hmacAlgorithm) {
                case "hmacsha1": {
                    return 20;
                }
            }
            return 32;
        }
    }
}

