/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.huaweicloud.sdk.core.exception.CallTimeoutException;
import com.huaweicloud.sdk.core.exception.ConnectionTimeoutException;
import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class ExceptionUtils {
    private static final String CONNECT_TIMEOUT_MSG = "connect timed out";

    private ExceptionUtils() {
    }

    public static SdkErrorMessage extractErrorMessage(HttpResponse httpResponse) {
        String strBody = httpResponse.getBodyAsString();
        SdkErrorMessage sdkErrorMessage = new SdkErrorMessage(httpResponse.getStatusCode());
        if (Objects.isNull(strBody)) {
            return sdkErrorMessage;
        }
        try {
            Map errResult = JsonUtils.toObject(strBody, Map.class);
            if (Objects.isNull(errResult)) {
                return sdkErrorMessage;
            }
            ExceptionUtils.processErrorMessage(sdkErrorMessage, errResult);
            if (Objects.isNull(sdkErrorMessage.getErrorMsg())) {
                sdkErrorMessage.setErrorMsg(strBody);
            }
        }
        catch (SdkException e) {
            sdkErrorMessage.setErrorMsg(httpResponse.getBodyAsString());
        }
        if (Objects.isNull(sdkErrorMessage.getRequestId()) && Objects.nonNull(httpResponse.getHeader("X-Request-Id"))) {
            sdkErrorMessage.setRequestId(httpResponse.getHeader("X-Request-Id"));
        }
        return sdkErrorMessage;
    }

    private static List<SdkErrorMessage> extractDetails(Object details) {
        if (!(details instanceof List)) {
            return null;
        }
        ArrayList<SdkErrorMessage> errors = new ArrayList<SdkErrorMessage>();
        for (Object detail : (List)details) {
            if (!(detail instanceof Map)) continue;
            SdkErrorMessage error = new SdkErrorMessage();
            ExceptionUtils.processErrorMessage(error, (Map)detail);
            errors.add(error);
        }
        return errors;
    }

    private static void processErrorMessage(SdkErrorMessage sdkErrorMessage, Map<?, ?> errResult) {
        Object details;
        Object encodedAuthMsg = errResult.get("encoded_authorization_message");
        if (Objects.nonNull(encodedAuthMsg)) {
            sdkErrorMessage.setEncodedAuthorizationMessage(encodedAuthMsg.toString());
        }
        if (Objects.nonNull(details = errResult.get("details"))) {
            sdkErrorMessage.setDetails(ExceptionUtils.extractDetails(details));
        }
        if (errResult.containsKey("error_code") && errResult.containsKey("error_msg")) {
            sdkErrorMessage.setErrorCode(errResult.get("error_code").toString());
            sdkErrorMessage.setErrorMsg(errResult.get("error_msg").toString());
            return;
        }
        if (errResult.containsKey("code") && errResult.containsKey("message")) {
            sdkErrorMessage.setErrorCode(errResult.get("code").toString());
            sdkErrorMessage.setErrorMsg(errResult.get("message").toString());
            return;
        }
        for (Object value : errResult.values()) {
            if (!(value instanceof Map)) continue;
            ExceptionUtils.processErrorMessage(sdkErrorMessage, (Map)value);
        }
    }

    public static void mapSocketTimeoutException(String originMsg, Throwable cause) {
        if (cause.getMessage().toLowerCase(Locale.ROOT).contains(CONNECT_TIMEOUT_MSG)) {
            throw new ConnectionTimeoutException(cause);
        }
        throw new CallTimeoutException(originMsg, cause);
    }
}

