/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.http;

import com.huaweicloud.sdk.core.HttpListener;
import com.huaweicloud.sdk.core.auth.SigningAlgorithm;
import com.huaweicloud.sdk.core.utils.RandomUtils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Dns;

public class HttpConfig {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60;
    private static final int DEFAULT_READ_TIMEOUT = 120;
    private int connectionTimeout = 60;
    private int readTimeout = 120;
    private boolean ignoreSSLVerification = false;
    private boolean ignoreRequiredValidation = false;
    private boolean allowRedirects = false;
    private boolean ignoreContentTypeForGetRequest = false;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyHost;
    private int proxyPort;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager trustManager;
    private List<HttpListener> httpListeners = new ArrayList<HttpListener>();
    private SigningAlgorithm signingAlgorithm = SigningAlgorithm.getDefault();
    private SecureRandom secureRandom = RandomUtils.getDefaultSecureRandom();
    private ConnectionPool connectionPool = new ConnectionPool(5, 5L, TimeUnit.MINUTES);
    private ExecutorService executorService = new ForkJoinPool();
    private Dispatcher dispatcher;
    private HostnameVerifier hostnameVerifier;
    private Dns dns;

    @Deprecated
    public int getTimeout() {
        return this.connectionTimeout;
    }

    @Deprecated
    public void setTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Deprecated
    public HttpConfig withTimeout(int timeout) {
        this.connectionTimeout = timeout;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public HttpConfig withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public HttpConfig withReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpConfig withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public HttpConfig withExecutorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public boolean isIgnoreSSLVerification() {
        return this.ignoreSSLVerification;
    }

    public void setIgnoreSSLVerification(boolean ignoreSSLVerification) {
        this.ignoreSSLVerification = ignoreSSLVerification;
    }

    public HttpConfig withIgnoreSSLVerification(boolean ignoreSSLVerification) {
        this.setIgnoreSSLVerification(ignoreSSLVerification);
        return this;
    }

    public boolean isIgnoreRequiredValidation() {
        return this.ignoreRequiredValidation;
    }

    public void setIgnoreRequiredValidation(boolean ignoreRequiredValidation) {
        this.ignoreRequiredValidation = ignoreRequiredValidation;
    }

    public HttpConfig withIgnoreRequiredValidation(boolean ignoreRequiredValidation) {
        this.setIgnoreRequiredValidation(ignoreRequiredValidation);
        return this;
    }

    public boolean isIgnoreContentTypeForGetRequest() {
        return this.ignoreContentTypeForGetRequest;
    }

    public void setIgnoreContentTypeForGetRequest(boolean ignoreContentTypeForGetRequest) {
        this.ignoreContentTypeForGetRequest = ignoreContentTypeForGetRequest;
    }

    public HttpConfig withIgnoreContentTypeForGetRequest(boolean ignoreContentTypeForGetRequest) {
        this.setIgnoreContentTypeForGetRequest(ignoreContentTypeForGetRequest);
        return this;
    }

    public boolean isAllowRedirects() {
        return this.allowRedirects;
    }

    public void setAllowRedirects(boolean allowRedirects) {
        this.allowRedirects = allowRedirects;
    }

    public HttpConfig withAllowRedirects(boolean allowRedirects) {
        this.setAllowRedirects(allowRedirects);
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public HttpConfig withProxyUsername(String proxyUsername) {
        this.setProxyUsername(proxyUsername);
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public HttpConfig withProxyPassword(String proxyPassword) {
        this.setProxyPassword(proxyPassword);
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public HttpConfig withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public HttpConfig withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public HttpConfig withSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    public void setX509TrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public HttpConfig withX509TrustManager(X509TrustManager trustManager) {
        this.setX509TrustManager(trustManager);
        return this;
    }

    public static HttpConfig getDefaultHttpConfig() {
        return new HttpConfig();
    }

    public List<HttpListener> getHttpListeners() {
        return this.httpListeners;
    }

    public void setHttpListeners(List<HttpListener> httpListeners) {
        this.httpListeners = httpListeners;
    }

    public HttpConfig withHttpListeners(List<HttpListener> httpListeners) {
        this.setHttpListeners(httpListeners);
        return this;
    }

    public HttpConfig addHttpListener(HttpListener httpListener) {
        if (Objects.nonNull(httpListener)) {
            this.httpListeners.add(httpListener);
        }
        return this;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public HttpConfig withConnectionPool(ConnectionPool connectionPool) {
        this.setConnectionPool(connectionPool);
        return this;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public HttpConfig withDispatcher(Dispatcher dispatcher) {
        this.setDispatcher(dispatcher);
        return this;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public HttpConfig withSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
        this.setSigningAlgorithm(signingAlgorithm);
        return this;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public HttpConfig withSecureRandom(SecureRandom secureRandom) {
        this.setSecureRandom(secureRandom);
        return this;
    }

    public Dns getDns() {
        return this.dns;
    }

    public void setDns(Dns dns) {
        this.dns = dns;
    }

    public HttpConfig withDns(Dns dns) {
        this.setDns(dns);
        return this;
    }
}

