/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.IAKSKSigner;
import com.huaweicloud.sdk.core.auth.P256SHA256Signer;
import com.huaweicloud.sdk.core.auth.SM2SM3Signer;
import com.huaweicloud.sdk.core.auth.SM3AKSKSigner;
import com.huaweicloud.sdk.core.auth.SigningAlgorithm;
import com.huaweicloud.sdk.core.exception.SdkException;

public class AKSKSignerFactory {
    public static IAKSKSigner getSigner(SigningAlgorithm algorithm) {
        switch (algorithm) {
            case HMAC_SHA256: {
                return AKSKSigner.getInstance();
            }
            case HMAC_SM3: {
                return SM3AKSKSigner.getInstance();
            }
            case ECDSA_P256_SHA256: {
                return P256SHA256Signer.getInstance();
            }
            case SM2_SM3: {
                return SM2SM3Signer.getInstance();
            }
        }
        throw new SdkException("unsupported signing algorithm: " + (Object)((Object)algorithm));
    }
}

