/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.exception;

import com.huaweicloud.sdk.core.exception.ClientRequestException;
import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServerResponseException;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.List;
import java.util.Objects;

public class ServiceResponseException
extends SdkException {
    private static final long serialVersionUID = 3963239618582355630L;
    private final int httpStatusCode;
    private final SdkErrorMessage sdkErrorMessage;

    public ServiceResponseException(int httpStatusCode, SdkErrorMessage sdkErrorMessage) {
        super(Objects.nonNull(sdkErrorMessage) ? sdkErrorMessage.getErrorMsg() : "ServiceResponseException");
        this.httpStatusCode = httpStatusCode;
        this.sdkErrorMessage = Objects.nonNull(sdkErrorMessage) ? sdkErrorMessage : new SdkErrorMessage();
    }

    public ServiceResponseException(int httpStatusCode, String errorCode, String errorMsg, String requestId) {
        super(errorMsg);
        this.httpStatusCode = httpStatusCode;
        this.sdkErrorMessage = new SdkErrorMessage().withErrorCode(errorCode).withErrorMsg(errorMsg).withRequestId(requestId);
    }

    public static ServiceResponseException mapException(int httpStatusCode, SdkErrorMessage sdkErrorMessage) {
        if (Objects.isNull(sdkErrorMessage)) {
            sdkErrorMessage = new SdkErrorMessage();
        }
        if (httpStatusCode >= 400 && httpStatusCode < 500) {
            return new ClientRequestException(httpStatusCode, sdkErrorMessage);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600) {
            return new ServerResponseException(httpStatusCode, sdkErrorMessage);
        }
        return new ServiceResponseException(httpStatusCode, sdkErrorMessage);
    }

    @Deprecated
    public static ServiceResponseException mapException(int httpStatusCode, String errorCode, String errorMsg, String requestId) {
        if (httpStatusCode >= 400 && httpStatusCode < 500) {
            return new ClientRequestException(httpStatusCode, errorCode, errorMsg, requestId);
        }
        if (httpStatusCode >= 500 && httpStatusCode < 600) {
            return new ServerResponseException(httpStatusCode, errorCode, errorMsg, requestId);
        }
        return new ServiceResponseException(httpStatusCode, errorCode, errorMsg, requestId);
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMsg() {
        return this.sdkErrorMessage.getErrorMsg();
    }

    public String getErrorCode() {
        return this.sdkErrorMessage.getErrorCode();
    }

    public String getRequestId() {
        return this.sdkErrorMessage.getRequestId();
    }

    public String getEncodedAuthorizationMessage() {
        return this.sdkErrorMessage.getEncodedAuthorizationMessage();
    }

    public List<SdkErrorMessage> getDetails() {
        return this.sdkErrorMessage.getDetails();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" {\n");
        sb.append("    httpStatusCode: ").append(this.toIndentedString(this.httpStatusCode)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.getErrorCode())).append("\n");
        sb.append("    errorMsg: ").append(this.toIndentedString(this.getErrorMsg())).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.getRequestId())).append("\n");
        if (!StringUtils.isEmpty(this.getEncodedAuthorizationMessage())) {
            sb.append("    encodedAuthorizationMessage: ").append(this.toIndentedString(this.getEncodedAuthorizationMessage())).append("\n");
        }
        if (Objects.nonNull(this.getDetails())) {
            sb.append("    details: ").append("[").append("\n");
            for (SdkErrorMessage detail : this.getDetails()) {
                sb.append("        {").append("\n");
                sb.append("             errorCode: ").append(this.toIndentedString(detail.getErrorCode())).append("\n");
                sb.append("             errorMsg: ").append(this.toIndentedString(detail.getErrorMsg())).append("\n");
                sb.append("        }").append("\n");
            }
            sb.append("    ]").append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

