/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.utils;

import com.mongodb.MongoClientSettings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

public class BsonUtils {
    public static <T> T toObject(byte[] buf, Class<T> clazz) {
        BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(buf, 0, buf.length));
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        return (T)codecRegistry.get(clazz).decode((BsonReader)reader, DecoderContext.builder().build());
    }

    public static <T> String toBSON(T sdkResponse) {
        BasicOutputBuffer output = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)output);
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        Codec codec = codecRegistry.get(sdkResponse.getClass());
        codec.encode((BsonWriter)writer, sdkResponse, EncoderContext.builder().build());
        byte[] buf = Arrays.copyOfRange(output.getInternalBuffer(), 0, output.size());
        String encodedString = Base64.getMimeEncoder().encodeToString(buf);
        return encodedString;
    }
}

