/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.corebson;

import com.huaweicloud.sdk.core.SdkStreamResponse;
import com.huaweicloud.sdk.corebson.InputStreamBsonInput;
import com.mongodb.MongoClientSettings;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.bson.BsonBinaryReader;
import org.bson.BsonReader;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.io.BsonInput;

public abstract class SdkBsonDocResponse
extends SdkStreamResponse {
    public Object parseBody(InputStream input) {
        return this.getBodyFromInputStream(input);
    }

    public Object parseBody(byte[] buf) {
        return this.getBodyFromBytes(buf);
    }

    public Object getBodyFromInputStream(InputStream input) {
        BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new InputStreamBsonInput(new BufferedInputStream(input)));
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        return this.decodeBody(codecRegistry, (BsonReader)reader);
    }

    public Object getBodyFromBytes(byte[] buf) {
        BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(buf, 0, buf.length));
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        return this.decodeBody(codecRegistry, (BsonReader)reader);
    }

    protected abstract Object decodeBody(CodecRegistry var1, BsonReader var2);
}

