/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.corebson;

import com.huaweicloud.sdk.core.exception.SdkException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.bson.BsonSerializationException;
import org.bson.io.BsonInput;
import org.bson.io.BsonInputMark;
import org.bson.types.ObjectId;

public class InputStreamBsonInput
implements BsonInput {
    private static int defaultBufferSize = 8192;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String[] ONE_BYTE_ASCII_STRINGS = new String[128];
    private BufferedInputStream buffer;
    private int pos = 0;
    private int mark = -1;

    InputStreamBsonInput(BufferedInputStream buffer) {
        this.buffer = buffer;
    }

    public int getPosition() {
        return this.pos;
    }

    public byte readByte() {
        byte[] bytes = new byte[1];
        this.ensureOpen();
        this.ensureReadSuccess(bytes, 0, 1);
        ++this.pos;
        return bytes[0];
    }

    public void readBytes(byte[] bytes) {
        this.ensureOpen();
        this.ensureReadSuccess(bytes, 0, bytes.length);
        this.pos += bytes.length;
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        this.ensureOpen();
        this.ensureReadSuccess(bytes, offset, length);
        this.pos += length;
    }

    public long readInt64() {
        byte[] bytes = new byte[8];
        this.ensureOpen();
        this.ensureReadSuccess(bytes, 0, 8);
        this.pos += 8;
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getLong();
    }

    public double readDouble() {
        byte[] bytes = new byte[8];
        this.ensureOpen();
        this.ensureReadSuccess(bytes, 0, 8);
        this.pos += 8;
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getDouble();
    }

    public int readInt32() {
        byte[] bytes = new byte[4];
        this.ensureOpen();
        this.ensureReadSuccess(bytes, 0, 4);
        this.pos += 4;
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getInt();
    }

    public String readString() {
        this.ensureOpen();
        int size = this.readInt32();
        if (size <= 0) {
            throw new BsonSerializationException(String.format("While decoding a BSON string found a size that is not a positive number: %d", size));
        }
        return this.readString(size);
    }

    public ObjectId readObjectId() {
        byte[] bytes = new byte[12];
        this.readBytes(bytes);
        return new ObjectId(bytes);
    }

    public String readCString() {
        this.ensureOpen();
        this.mark = this.pos;
        this.buffer.mark(defaultBufferSize);
        this.readUntilNullByte();
        int size = this.pos - this.mark;
        try {
            this.buffer.reset();
            this.pos = this.mark;
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
        return this.readString(size);
    }

    public void skipCString() {
        this.ensureOpen();
        this.readUntilNullByte();
    }

    public void skip(int numBytes) {
        this.ensureOpen();
        try {
            long skipped = this.buffer.skip(numBytes);
            this.pos = (int)((long)this.pos + skipped);
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    @Deprecated
    public void mark(int readLimit) {
        this.ensureOpen();
        this.buffer.mark(readLimit);
        this.mark = this.pos;
    }

    public BsonInputMark getMark(int readLimit) {
        this.buffer.mark(readLimit);
        this.mark = this.pos;
        return new BsonInputMark(){

            public void reset() {
                InputStreamBsonInput.this.ensureOpen();
                try {
                    InputStreamBsonInput.this.buffer.reset();
                    InputStreamBsonInput.this.pos = InputStreamBsonInput.this.mark;
                }
                catch (IOException e) {
                    throw new SdkException((Throwable)e);
                }
            }
        };
    }

    @Deprecated
    public void reset() {
        try {
            this.ensureOpen();
            if (this.mark < 0) {
                throw new IOException("Resetting to invalid mark");
            }
            this.buffer.reset();
            this.pos = this.mark;
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public boolean hasRemaining() {
        this.ensureOpen();
        try {
            return this.buffer.available() > 0;
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void close() {
        try {
            this.buffer.close();
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    private void ensureReadSuccess(byte[] bytes, int offset, int len) {
        int n = len;
        while (len > 0) {
            try {
                int r = this.buffer.read(bytes, offset, len);
                if (r == -1) {
                    throw new BsonSerializationException(String.format("While decoding a BSON document %d bytes were required, but only %d remain", n, n - len));
                }
                len -= r;
                offset += r;
                Thread.sleep(50L);
            }
            catch (IOException | InterruptedException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    private String readString(int size) {
        if (size == 2) {
            byte asciiByte = this.readByte();
            byte nullByte = this.readByte();
            if (nullByte != 0) {
                throw new BsonSerializationException("Found a BSON string that is not null-terminated");
            }
            if (asciiByte < 0) {
                return UTF8_CHARSET.newDecoder().replacement();
            }
            return ONE_BYTE_ASCII_STRINGS[asciiByte];
        }
        byte[] bytes = new byte[size - 1];
        this.readBytes(bytes);
        byte nullByte = this.readByte();
        if (nullByte != 0) {
            throw new BsonSerializationException("Found a BSON string that is not null-terminated");
        }
        return new String(bytes, UTF8_CHARSET);
    }

    private void readUntilNullByte() {
        while (this.readByte() != 0) {
        }
    }

    static {
        for (int b = 0; b < ONE_BYTE_ASCII_STRINGS.length; ++b) {
            InputStreamBsonInput.ONE_BYTE_ASCII_STRINGS[b] = String.valueOf((char)b);
        }
    }
}

