/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.codeartsdeploy.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.codeartsdeploy.v2.model.DeploymentHostAuthorizationBody;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DeploymentHost {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="host_name")
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ip")
    private String ip;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="port")
    private Integer port;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="os")
    private OsEnum os;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="as_proxy")
    private Boolean asProxy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="proxy_host_id")
    private String proxyHostId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authorization")
    private DeploymentHostAuthorizationBody authorization;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="install_icagent")
    private Boolean installIcagent;

    public DeploymentHost withHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public DeploymentHost withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public DeploymentHost withPort(Integer port) {
        this.port = port;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public DeploymentHost withOs(OsEnum os) {
        this.os = os;
        return this;
    }

    public OsEnum getOs() {
        return this.os;
    }

    public void setOs(OsEnum os) {
        this.os = os;
    }

    public DeploymentHost withAsProxy(Boolean asProxy) {
        this.asProxy = asProxy;
        return this;
    }

    public Boolean getAsProxy() {
        return this.asProxy;
    }

    public void setAsProxy(Boolean asProxy) {
        this.asProxy = asProxy;
    }

    public DeploymentHost withProxyHostId(String proxyHostId) {
        this.proxyHostId = proxyHostId;
        return this;
    }

    public String getProxyHostId() {
        return this.proxyHostId;
    }

    public void setProxyHostId(String proxyHostId) {
        this.proxyHostId = proxyHostId;
    }

    public DeploymentHost withAuthorization(DeploymentHostAuthorizationBody authorization) {
        this.authorization = authorization;
        return this;
    }

    public DeploymentHost withAuthorization(Consumer<DeploymentHostAuthorizationBody> authorizationSetter) {
        if (this.authorization == null) {
            this.authorization = new DeploymentHostAuthorizationBody();
            authorizationSetter.accept(this.authorization);
        }
        return this;
    }

    public DeploymentHostAuthorizationBody getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(DeploymentHostAuthorizationBody authorization) {
        this.authorization = authorization;
    }

    public DeploymentHost withInstallIcagent(Boolean installIcagent) {
        this.installIcagent = installIcagent;
        return this;
    }

    public Boolean getInstallIcagent() {
        return this.installIcagent;
    }

    public void setInstallIcagent(Boolean installIcagent) {
        this.installIcagent = installIcagent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentHost that = (DeploymentHost)obj;
        return Objects.equals(this.hostName, that.hostName) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port) && Objects.equals(this.os, that.os) && Objects.equals(this.asProxy, that.asProxy) && Objects.equals(this.proxyHostId, that.proxyHostId) && Objects.equals(this.authorization, that.authorization) && Objects.equals(this.installIcagent, that.installIcagent);
    }

    public int hashCode() {
        return Objects.hash(this.hostName, this.ip, this.port, this.os, this.asProxy, this.proxyHostId, this.authorization, this.installIcagent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentHost {\n");
        sb.append("    hostName: ").append(this.toIndentedString(this.hostName)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    asProxy: ").append(this.toIndentedString(this.asProxy)).append("\n");
        sb.append("    proxyHostId: ").append(this.toIndentedString(this.proxyHostId)).append("\n");
        sb.append("    authorization: ").append(this.toIndentedString(this.authorization)).append("\n");
        sb.append("    installIcagent: ").append(this.toIndentedString(this.installIcagent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class OsEnum {
        public static final OsEnum WINDOWS = new OsEnum("windows");
        public static final OsEnum LINUX = new OsEnum("linux");
        private static final Map<String, OsEnum> STATIC_FIELDS = OsEnum.createStaticFields();
        private String value;

        private static Map<String, OsEnum> createStaticFields() {
            HashMap<String, OsEnum> map = new HashMap<String, OsEnum>();
            map.put("windows", WINDOWS);
            map.put("linux", LINUX);
            return Collections.unmodifiableMap(map);
        }

        OsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OsEnum(value));
        }

        public static OsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OsEnum) {
                return this.value.equals(((OsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

