/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoCCE;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoCSE;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoNacosBase;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MicroServiceInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_type")
    private ServiceTypeEnum serviceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cse_info")
    private MicroServiceInfoCSE cseInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cce_info")
    private MicroServiceInfoCCE cceInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nacos_info")
    private MicroServiceInfoNacosBase nacosInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="update_time")
    private OffsetDateTime updateTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="create_time")
    private OffsetDateTime createTime;

    public MicroServiceInfo withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MicroServiceInfo withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public MicroServiceInfo withServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public MicroServiceInfo withCseInfo(MicroServiceInfoCSE cseInfo) {
        this.cseInfo = cseInfo;
        return this;
    }

    public MicroServiceInfo withCseInfo(Consumer<MicroServiceInfoCSE> cseInfoSetter) {
        if (this.cseInfo == null) {
            this.cseInfo = new MicroServiceInfoCSE();
            cseInfoSetter.accept(this.cseInfo);
        }
        return this;
    }

    public MicroServiceInfoCSE getCseInfo() {
        return this.cseInfo;
    }

    public void setCseInfo(MicroServiceInfoCSE cseInfo) {
        this.cseInfo = cseInfo;
    }

    public MicroServiceInfo withCceInfo(MicroServiceInfoCCE cceInfo) {
        this.cceInfo = cceInfo;
        return this;
    }

    public MicroServiceInfo withCceInfo(Consumer<MicroServiceInfoCCE> cceInfoSetter) {
        if (this.cceInfo == null) {
            this.cceInfo = new MicroServiceInfoCCE();
            cceInfoSetter.accept(this.cceInfo);
        }
        return this;
    }

    public MicroServiceInfoCCE getCceInfo() {
        return this.cceInfo;
    }

    public void setCceInfo(MicroServiceInfoCCE cceInfo) {
        this.cceInfo = cceInfo;
    }

    public MicroServiceInfo withNacosInfo(MicroServiceInfoNacosBase nacosInfo) {
        this.nacosInfo = nacosInfo;
        return this;
    }

    public MicroServiceInfo withNacosInfo(Consumer<MicroServiceInfoNacosBase> nacosInfoSetter) {
        if (this.nacosInfo == null) {
            this.nacosInfo = new MicroServiceInfoNacosBase();
            nacosInfoSetter.accept(this.nacosInfo);
        }
        return this;
    }

    public MicroServiceInfoNacosBase getNacosInfo() {
        return this.nacosInfo;
    }

    public void setNacosInfo(MicroServiceInfoNacosBase nacosInfo) {
        this.nacosInfo = nacosInfo;
    }

    public MicroServiceInfo withUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public MicroServiceInfo withCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MicroServiceInfo that = (MicroServiceInfo)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.cseInfo, that.cseInfo) && Objects.equals(this.cceInfo, that.cceInfo) && Objects.equals(this.nacosInfo, that.nacosInfo) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.createTime, that.createTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.instanceId, this.serviceType, this.cseInfo, this.cceInfo, this.nacosInfo, this.updateTime, this.createTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MicroServiceInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    cseInfo: ").append(this.toIndentedString(this.cseInfo)).append("\n");
        sb.append("    cceInfo: ").append(this.toIndentedString(this.cceInfo)).append("\n");
        sb.append("    nacosInfo: ").append(this.toIndentedString(this.nacosInfo)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ServiceTypeEnum {
        public static final ServiceTypeEnum CSE = new ServiceTypeEnum("CSE");
        public static final ServiceTypeEnum CCE = new ServiceTypeEnum("CCE");
        public static final ServiceTypeEnum CCE_SERVICE = new ServiceTypeEnum("CCE_SERVICE");
        public static final ServiceTypeEnum NACOS = new ServiceTypeEnum("NACOS");
        private static final Map<String, ServiceTypeEnum> STATIC_FIELDS = ServiceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ServiceTypeEnum> createStaticFields() {
            HashMap<String, ServiceTypeEnum> map = new HashMap<String, ServiceTypeEnum>();
            map.put("CSE", CSE);
            map.put("CCE", CCE);
            map.put("CCE_SERVICE", CCE_SERVICE);
            map.put("NACOS", NACOS);
            return Collections.unmodifiableMap(map);
        }

        ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ServiceTypeEnum(value));
        }

        public static ServiceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceTypeEnum) {
                return this.value.equals(((ServiceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

