/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoCCEBase;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoCSEBase;
import com.huaweicloud.sdk.apig.v2.model.MicroServiceInfoNacosBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MicroServiceCreate {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_type")
    private ServiceTypeEnum serviceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cse_info")
    private MicroServiceInfoCSEBase cseInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cce_info")
    private MicroServiceInfoCCEBase cceInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nacos_info")
    private MicroServiceInfoNacosBase nacosInfo;

    public MicroServiceCreate withServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public MicroServiceCreate withCseInfo(MicroServiceInfoCSEBase cseInfo) {
        this.cseInfo = cseInfo;
        return this;
    }

    public MicroServiceCreate withCseInfo(Consumer<MicroServiceInfoCSEBase> cseInfoSetter) {
        if (this.cseInfo == null) {
            this.cseInfo = new MicroServiceInfoCSEBase();
            cseInfoSetter.accept(this.cseInfo);
        }
        return this;
    }

    public MicroServiceInfoCSEBase getCseInfo() {
        return this.cseInfo;
    }

    public void setCseInfo(MicroServiceInfoCSEBase cseInfo) {
        this.cseInfo = cseInfo;
    }

    public MicroServiceCreate withCceInfo(MicroServiceInfoCCEBase cceInfo) {
        this.cceInfo = cceInfo;
        return this;
    }

    public MicroServiceCreate withCceInfo(Consumer<MicroServiceInfoCCEBase> cceInfoSetter) {
        if (this.cceInfo == null) {
            this.cceInfo = new MicroServiceInfoCCEBase();
            cceInfoSetter.accept(this.cceInfo);
        }
        return this;
    }

    public MicroServiceInfoCCEBase getCceInfo() {
        return this.cceInfo;
    }

    public void setCceInfo(MicroServiceInfoCCEBase cceInfo) {
        this.cceInfo = cceInfo;
    }

    public MicroServiceCreate withNacosInfo(MicroServiceInfoNacosBase nacosInfo) {
        this.nacosInfo = nacosInfo;
        return this;
    }

    public MicroServiceCreate withNacosInfo(Consumer<MicroServiceInfoNacosBase> nacosInfoSetter) {
        if (this.nacosInfo == null) {
            this.nacosInfo = new MicroServiceInfoNacosBase();
            nacosInfoSetter.accept(this.nacosInfo);
        }
        return this;
    }

    public MicroServiceInfoNacosBase getNacosInfo() {
        return this.nacosInfo;
    }

    public void setNacosInfo(MicroServiceInfoNacosBase nacosInfo) {
        this.nacosInfo = nacosInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MicroServiceCreate that = (MicroServiceCreate)obj;
        return Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.cseInfo, that.cseInfo) && Objects.equals(this.cceInfo, that.cceInfo) && Objects.equals(this.nacosInfo, that.nacosInfo);
    }

    public int hashCode() {
        return Objects.hash(this.serviceType, this.cseInfo, this.cceInfo, this.nacosInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MicroServiceCreate {\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("    cseInfo: ").append(this.toIndentedString(this.cseInfo)).append("\n");
        sb.append("    cceInfo: ").append(this.toIndentedString(this.cceInfo)).append("\n");
        sb.append("    nacosInfo: ").append(this.toIndentedString(this.nacosInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ServiceTypeEnum {
        public static final ServiceTypeEnum CSE = new ServiceTypeEnum("CSE");
        public static final ServiceTypeEnum CCE = new ServiceTypeEnum("CCE");
        public static final ServiceTypeEnum CCE_SERVICE = new ServiceTypeEnum("CCE_SERVICE");
        public static final ServiceTypeEnum NACOS = new ServiceTypeEnum("NACOS");
        private static final Map<String, ServiceTypeEnum> STATIC_FIELDS = ServiceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ServiceTypeEnum> createStaticFields() {
            HashMap<String, ServiceTypeEnum> map = new HashMap<String, ServiceTypeEnum>();
            map.put("CSE", CSE);
            map.put("CCE", CCE);
            map.put("CCE_SERVICE", CCE_SERVICE);
            map.put("NACOS", NACOS);
            return Collections.unmodifiableMap(map);
        }

        ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ServiceTypeEnum(value));
        }

        public static ServiceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceTypeEnum) {
                return this.value.equals(((ServiceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

