/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressPortInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="protocol")
    private ProtocolEnum protocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ingress_port")
    private Integer ingressPort;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ingress_port_id")
    private String ingressPortId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;

    public IngressPortInfo withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public IngressPortInfo withIngressPort(Integer ingressPort) {
        this.ingressPort = ingressPort;
        return this;
    }

    public Integer getIngressPort() {
        return this.ingressPort;
    }

    public void setIngressPort(Integer ingressPort) {
        this.ingressPort = ingressPort;
    }

    public IngressPortInfo withIngressPortId(String ingressPortId) {
        this.ingressPortId = ingressPortId;
        return this;
    }

    public String getIngressPortId() {
        return this.ingressPortId;
    }

    public void setIngressPortId(String ingressPortId) {
        this.ingressPortId = ingressPortId;
    }

    public IngressPortInfo withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IngressPortInfo that = (IngressPortInfo)obj;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.ingressPort, that.ingressPort) && Objects.equals(this.ingressPortId, that.ingressPortId) && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.ingressPort, this.ingressPortId, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IngressPortInfo {\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    ingressPort: ").append(this.toIndentedString(this.ingressPort)).append("\n");
        sb.append("    ingressPortId: ").append(this.toIndentedString(this.ingressPortId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum NORMAL = new StatusEnum("normal");
        public static final StatusEnum ABNORMAL = new StatusEnum("abnormal");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("normal", NORMAL);
            map.put("abnormal", ABNORMAL);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ProtocolEnum {
        public static final ProtocolEnum HTTP = new ProtocolEnum("HTTP");
        public static final ProtocolEnum HTTPS = new ProtocolEnum("HTTPS");
        private static final Map<String, ProtocolEnum> STATIC_FIELDS = ProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, ProtocolEnum> createStaticFields() {
            HashMap<String, ProtocolEnum> map = new HashMap<String, ProtocolEnum>();
            map.put("HTTP", HTTP);
            map.put("HTTPS", HTTPS);
            return Collections.unmodifiableMap(map);
        }

        ProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ProtocolEnum(value));
        }

        public static ProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProtocolEnum) {
                return this.value.equals(((ProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

