/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.apig.v2.model.ExportOpenApiReq;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ExportApiDefinitionsAsyncRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="instance_id")
    private String instanceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="oas_version")
    private OasVersionEnum oasVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private ExportOpenApiReq body;

    public ExportApiDefinitionsAsyncRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ExportApiDefinitionsAsyncRequest withOasVersion(OasVersionEnum oasVersion) {
        this.oasVersion = oasVersion;
        return this;
    }

    public OasVersionEnum getOasVersion() {
        return this.oasVersion;
    }

    public void setOasVersion(OasVersionEnum oasVersion) {
        this.oasVersion = oasVersion;
    }

    public ExportApiDefinitionsAsyncRequest withBody(ExportOpenApiReq body) {
        this.body = body;
        return this;
    }

    public ExportApiDefinitionsAsyncRequest withBody(Consumer<ExportOpenApiReq> bodySetter) {
        if (this.body == null) {
            this.body = new ExportOpenApiReq();
            bodySetter.accept(this.body);
        }
        return this;
    }

    public ExportOpenApiReq getBody() {
        return this.body;
    }

    public void setBody(ExportOpenApiReq body) {
        this.body = body;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExportApiDefinitionsAsyncRequest that = (ExportApiDefinitionsAsyncRequest)obj;
        return Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.oasVersion, that.oasVersion) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.oasVersion, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportApiDefinitionsAsyncRequest {\n");
        sb.append("    instanceId: ").append(this.toIndentedString(this.instanceId)).append("\n");
        sb.append("    oasVersion: ").append(this.toIndentedString(this.oasVersion)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class OasVersionEnum {
        public static final OasVersionEnum _2_0 = new OasVersionEnum("2.0");
        public static final OasVersionEnum _3_0 = new OasVersionEnum("3.0");
        private static final Map<String, OasVersionEnum> STATIC_FIELDS = OasVersionEnum.createStaticFields();
        private String value;

        private static Map<String, OasVersionEnum> createStaticFields() {
            HashMap<String, OasVersionEnum> map = new HashMap<String, OasVersionEnum>();
            map.put("2.0", _2_0);
            map.put("3.0", _3_0);
            return Collections.unmodifiableMap(map);
        }

        OasVersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OasVersionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OasVersionEnum(value));
        }

        public static OasVersionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OasVersionEnum) {
                return this.value.equals(((OasVersionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

