/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ConnectionActionReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="endpoints")
    private List<String> endpoints = null;

    public ConnectionActionReq withAction(ActionEnum action) {
        this.action = action;
        return this;
    }

    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ConnectionActionReq withEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public ConnectionActionReq addEndpointsItem(String endpointsItem) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(endpointsItem);
        return this;
    }

    public ConnectionActionReq withEndpoints(Consumer<List<String>> endpointsSetter) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        endpointsSetter.accept(this.endpoints);
        return this;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionActionReq that = (ConnectionActionReq)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.endpoints, that.endpoints);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.endpoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionActionReq {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ActionEnum {
        public static final ActionEnum RECEIVE = new ActionEnum("receive");
        public static final ActionEnum REJECT = new ActionEnum("reject");
        private static final Map<String, ActionEnum> STATIC_FIELDS = ActionEnum.createStaticFields();
        private String value;

        private static Map<String, ActionEnum> createStaticFields() {
            HashMap<String, ActionEnum> map = new HashMap<String, ActionEnum>();
            map.put("receive", RECEIVE);
            map.put("reject", REJECT);
            return Collections.unmodifiableMap(map);
        }

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ActionEnum(value));
        }

        public static ActionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionEnum) {
                return this.value.equals(((ActionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

