/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ApiDebugInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private String body;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="header")
    private Map<String, List<String>> header = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="method")
    private MethodEnum method;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="mode")
    private String mode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="path")
    private String path;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="query")
    private Map<String, List<String>> query = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="scheme")
    private String scheme;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_key")
    private String appKey;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_secret")
    private String appSecret;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain")
    private String domain;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="stage")
    private String stage;

    public ApiDebugInfo withBody(String body) {
        this.body = body;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ApiDebugInfo withHeader(Map<String, List<String>> header) {
        this.header = header;
        return this;
    }

    public ApiDebugInfo putHeaderItem(String key, List<String> headerItem) {
        if (this.header == null) {
            this.header = new HashMap<String, List<String>>();
        }
        this.header.put(key, headerItem);
        return this;
    }

    public ApiDebugInfo withHeader(Consumer<Map<String, List<String>>> headerSetter) {
        if (this.header == null) {
            this.header = new HashMap<String, List<String>>();
        }
        headerSetter.accept(this.header);
        return this;
    }

    public Map<String, List<String>> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, List<String>> header) {
        this.header = header;
    }

    public ApiDebugInfo withMethod(MethodEnum method) {
        this.method = method;
        return this;
    }

    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public ApiDebugInfo withMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public ApiDebugInfo withPath(String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ApiDebugInfo withQuery(Map<String, List<String>> query) {
        this.query = query;
        return this;
    }

    public ApiDebugInfo putQueryItem(String key, List<String> queryItem) {
        if (this.query == null) {
            this.query = new HashMap<String, List<String>>();
        }
        this.query.put(key, queryItem);
        return this;
    }

    public ApiDebugInfo withQuery(Consumer<Map<String, List<String>>> querySetter) {
        if (this.query == null) {
            this.query = new HashMap<String, List<String>>();
        }
        querySetter.accept(this.query);
        return this;
    }

    public Map<String, List<String>> getQuery() {
        return this.query;
    }

    public void setQuery(Map<String, List<String>> query) {
        this.query = query;
    }

    public ApiDebugInfo withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ApiDebugInfo withAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public ApiDebugInfo withAppSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public ApiDebugInfo withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ApiDebugInfo withStage(String stage) {
        this.stage = stage;
        return this;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiDebugInfo that = (ApiDebugInfo)obj;
        return Objects.equals(this.body, that.body) && Objects.equals(this.header, that.header) && Objects.equals(this.method, that.method) && Objects.equals(this.mode, that.mode) && Objects.equals(this.path, that.path) && Objects.equals(this.query, that.query) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.appKey, that.appKey) && Objects.equals(this.appSecret, that.appSecret) && Objects.equals(this.domain, that.domain) && Objects.equals(this.stage, that.stage);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.header, this.method, this.mode, this.path, this.query, this.scheme, this.appKey, this.appSecret, this.domain, this.stage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDebugInfo {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("    appKey: ").append(this.toIndentedString(this.appKey)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString(this.stage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodEnum {
        public static final MethodEnum GET = new MethodEnum("GET");
        public static final MethodEnum POST = new MethodEnum("POST");
        public static final MethodEnum PUT = new MethodEnum("PUT");
        public static final MethodEnum DELETE = new MethodEnum("DELETE");
        public static final MethodEnum HEAD = new MethodEnum("HEAD");
        public static final MethodEnum PATCH = new MethodEnum("PATCH");
        public static final MethodEnum OPTIONS = new MethodEnum("OPTIONS");
        private static final Map<String, MethodEnum> STATIC_FIELDS = MethodEnum.createStaticFields();
        private String value;

        private static Map<String, MethodEnum> createStaticFields() {
            HashMap<String, MethodEnum> map = new HashMap<String, MethodEnum>();
            map.put("GET", GET);
            map.put("POST", POST);
            map.put("PUT", PUT);
            map.put("DELETE", DELETE);
            map.put("HEAD", HEAD);
            map.put("PATCH", PATCH);
            map.put("OPTIONS", OPTIONS);
            return Collections.unmodifiableMap(map);
        }

        MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new MethodEnum(value));
        }

        public static MethodEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodEnum) {
                return this.value.equals(((MethodEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

