/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.apig.v2.model.AuthResult;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ApiAuthRelations {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="api_id")
    private String apiId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_result")
    private AuthResult authResult;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_time")
    private OffsetDateTime authTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="app_id")
    private String appId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_role")
    private AuthRoleEnum authRole;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_tunnel")
    private AuthTunnelEnum authTunnel;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_whitelist")
    private List<String> authWhitelist = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auth_blacklist")
    private List<String> authBlacklist = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="visit_params")
    private String visitParams;

    public ApiAuthRelations withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public ApiAuthRelations withAuthResult(AuthResult authResult) {
        this.authResult = authResult;
        return this;
    }

    public ApiAuthRelations withAuthResult(Consumer<AuthResult> authResultSetter) {
        if (this.authResult == null) {
            this.authResult = new AuthResult();
            authResultSetter.accept(this.authResult);
        }
        return this;
    }

    public AuthResult getAuthResult() {
        return this.authResult;
    }

    public void setAuthResult(AuthResult authResult) {
        this.authResult = authResult;
    }

    public ApiAuthRelations withAuthTime(OffsetDateTime authTime) {
        this.authTime = authTime;
        return this;
    }

    public OffsetDateTime getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(OffsetDateTime authTime) {
        this.authTime = authTime;
    }

    public ApiAuthRelations withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApiAuthRelations withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public ApiAuthRelations withAuthRole(AuthRoleEnum authRole) {
        this.authRole = authRole;
        return this;
    }

    public AuthRoleEnum getAuthRole() {
        return this.authRole;
    }

    public void setAuthRole(AuthRoleEnum authRole) {
        this.authRole = authRole;
    }

    public ApiAuthRelations withAuthTunnel(AuthTunnelEnum authTunnel) {
        this.authTunnel = authTunnel;
        return this;
    }

    public AuthTunnelEnum getAuthTunnel() {
        return this.authTunnel;
    }

    public void setAuthTunnel(AuthTunnelEnum authTunnel) {
        this.authTunnel = authTunnel;
    }

    public ApiAuthRelations withAuthWhitelist(List<String> authWhitelist) {
        this.authWhitelist = authWhitelist;
        return this;
    }

    public ApiAuthRelations addAuthWhitelistItem(String authWhitelistItem) {
        if (this.authWhitelist == null) {
            this.authWhitelist = new ArrayList<String>();
        }
        this.authWhitelist.add(authWhitelistItem);
        return this;
    }

    public ApiAuthRelations withAuthWhitelist(Consumer<List<String>> authWhitelistSetter) {
        if (this.authWhitelist == null) {
            this.authWhitelist = new ArrayList<String>();
        }
        authWhitelistSetter.accept(this.authWhitelist);
        return this;
    }

    public List<String> getAuthWhitelist() {
        return this.authWhitelist;
    }

    public void setAuthWhitelist(List<String> authWhitelist) {
        this.authWhitelist = authWhitelist;
    }

    public ApiAuthRelations withAuthBlacklist(List<String> authBlacklist) {
        this.authBlacklist = authBlacklist;
        return this;
    }

    public ApiAuthRelations addAuthBlacklistItem(String authBlacklistItem) {
        if (this.authBlacklist == null) {
            this.authBlacklist = new ArrayList<String>();
        }
        this.authBlacklist.add(authBlacklistItem);
        return this;
    }

    public ApiAuthRelations withAuthBlacklist(Consumer<List<String>> authBlacklistSetter) {
        if (this.authBlacklist == null) {
            this.authBlacklist = new ArrayList<String>();
        }
        authBlacklistSetter.accept(this.authBlacklist);
        return this;
    }

    public List<String> getAuthBlacklist() {
        return this.authBlacklist;
    }

    public void setAuthBlacklist(List<String> authBlacklist) {
        this.authBlacklist = authBlacklist;
    }

    public ApiAuthRelations withVisitParams(String visitParams) {
        this.visitParams = visitParams;
        return this;
    }

    public String getVisitParams() {
        return this.visitParams;
    }

    public void setVisitParams(String visitParams) {
        this.visitParams = visitParams;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiAuthRelations that = (ApiAuthRelations)obj;
        return Objects.equals(this.apiId, that.apiId) && Objects.equals(this.authResult, that.authResult) && Objects.equals(this.authTime, that.authTime) && Objects.equals(this.id, that.id) && Objects.equals(this.appId, that.appId) && Objects.equals(this.authRole, that.authRole) && Objects.equals(this.authTunnel, that.authTunnel) && Objects.equals(this.authWhitelist, that.authWhitelist) && Objects.equals(this.authBlacklist, that.authBlacklist) && Objects.equals(this.visitParams, that.visitParams);
    }

    public int hashCode() {
        return Objects.hash(this.apiId, this.authResult, this.authTime, this.id, this.appId, this.authRole, this.authTunnel, this.authWhitelist, this.authBlacklist, this.visitParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAuthRelations {\n");
        sb.append("    apiId: ").append(this.toIndentedString(this.apiId)).append("\n");
        sb.append("    authResult: ").append(this.toIndentedString(this.authResult)).append("\n");
        sb.append("    authTime: ").append(this.toIndentedString(this.authTime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    authRole: ").append(this.toIndentedString(this.authRole)).append("\n");
        sb.append("    authTunnel: ").append(this.toIndentedString(this.authTunnel)).append("\n");
        sb.append("    authWhitelist: ").append(this.toIndentedString(this.authWhitelist)).append("\n");
        sb.append("    authBlacklist: ").append(this.toIndentedString(this.authBlacklist)).append("\n");
        sb.append("    visitParams: ").append(this.toIndentedString(this.visitParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class AuthTunnelEnum {
        public static final AuthTunnelEnum NORMAL = new AuthTunnelEnum("NORMAL");
        public static final AuthTunnelEnum GREEN = new AuthTunnelEnum("GREEN");
        private static final Map<String, AuthTunnelEnum> STATIC_FIELDS = AuthTunnelEnum.createStaticFields();
        private String value;

        private static Map<String, AuthTunnelEnum> createStaticFields() {
            HashMap<String, AuthTunnelEnum> map = new HashMap<String, AuthTunnelEnum>();
            map.put("NORMAL", NORMAL);
            map.put("GREEN", GREEN);
            return Collections.unmodifiableMap(map);
        }

        AuthTunnelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthTunnelEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AuthTunnelEnum(value));
        }

        public static AuthTunnelEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AuthTunnelEnum) {
                return this.value.equals(((AuthTunnelEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class AuthRoleEnum {
        public static final AuthRoleEnum PROVIDER = new AuthRoleEnum("PROVIDER");
        public static final AuthRoleEnum CONSUMER = new AuthRoleEnum("CONSUMER");
        private static final Map<String, AuthRoleEnum> STATIC_FIELDS = AuthRoleEnum.createStaticFields();
        private String value;

        private static Map<String, AuthRoleEnum> createStaticFields() {
            HashMap<String, AuthRoleEnum> map = new HashMap<String, AuthRoleEnum>();
            map.put("PROVIDER", PROVIDER);
            map.put("CONSUMER", CONSUMER);
            return Collections.unmodifiableMap(map);
        }

        AuthRoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthRoleEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AuthRoleEnum(value));
        }

        public static AuthRoleEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AuthRoleEnum) {
                return this.value.equals(((AuthRoleEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

