/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.apig.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ApiActionInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="env_id")
    private String envId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="api_id")
    private String apiId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="remark")
    private String remark;

    public ApiActionInfo withAction(ActionEnum action) {
        this.action = action;
        return this;
    }

    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ApiActionInfo withEnvId(String envId) {
        this.envId = envId;
        return this;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public ApiActionInfo withApiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public ApiActionInfo withRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiActionInfo that = (ApiActionInfo)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.envId, that.envId) && Objects.equals(this.apiId, that.apiId) && Objects.equals(this.remark, that.remark);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.envId, this.apiId, this.remark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiActionInfo {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    envId: ").append(this.toIndentedString(this.envId)).append("\n");
        sb.append("    apiId: ").append(this.toIndentedString(this.apiId)).append("\n");
        sb.append("    remark: ").append(this.toIndentedString(this.remark)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ActionEnum {
        public static final ActionEnum ONLINE = new ActionEnum("online");
        public static final ActionEnum OFFLINE = new ActionEnum("offline");
        private static final Map<String, ActionEnum> STATIC_FIELDS = ActionEnum.createStaticFields();
        private String value;

        private static Map<String, ActionEnum> createStaticFields() {
            HashMap<String, ActionEnum> map = new HashMap<String, ActionEnum>();
            map.put("online", ONLINE);
            map.put("offline", OFFLINE);
            return Collections.unmodifiableMap(map);
        }

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ActionEnum(value));
        }

        public static ActionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionEnum) {
                return this.value.equals(((ActionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

