/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ValueData {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="metric_name")
    private String metricName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="unit")
    private String unit;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private Double value;

    public ValueData withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public ValueData withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ValueData withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public ValueData withValue(Double value) {
        this.value = value;
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ValueData that = (ValueData)obj;
        return Objects.equals(this.metricName, that.metricName) && Objects.equals(this.type, that.type) && Objects.equals(this.unit, that.unit) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.type, this.unit, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValueData {\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum INT = new TypeEnum("int");
        public static final TypeEnum FLOAT = new TypeEnum("float");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("int", INT);
            map.put("float", FLOAT);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

