/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class RelationModel {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key")
    private String key;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private List<String> value = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="relation")
    private RelationEnum relation;

    public RelationModel withKey(String key) {
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public RelationModel withValue(List<String> value) {
        this.value = value;
        return this;
    }

    public RelationModel addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    public RelationModel withValue(Consumer<List<String>> valueSetter) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        valueSetter.accept(this.value);
        return this;
    }

    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public RelationModel withRelation(RelationEnum relation) {
        this.relation = relation;
        return this;
    }

    public RelationEnum getRelation() {
        return this.relation;
    }

    public void setRelation(RelationEnum relation) {
        this.relation = relation;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationModel that = (RelationModel)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.relation, that.relation);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.relation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationModel {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class RelationEnum {
        public static final RelationEnum AND = new RelationEnum("AND");
        public static final RelationEnum OR = new RelationEnum("OR");
        public static final RelationEnum NOT = new RelationEnum("NOT");
        private static final Map<String, RelationEnum> STATIC_FIELDS = RelationEnum.createStaticFields();
        private String value;

        private static Map<String, RelationEnum> createStaticFields() {
            HashMap<String, RelationEnum> map = new HashMap<String, RelationEnum>();
            map.put("AND", AND);
            map.put("OR", OR);
            map.put("NOT", NOT);
            return Collections.unmodifiableMap(map);
        }

        RelationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelationEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new RelationEnum(value));
        }

        public static RelationEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof RelationEnum) {
                return this.value.equals(((RelationEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

