/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.aom.v2.model.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class QueryMetricItemOptionParam {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="dimensions")
    private List<Dimension> dimensions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="metricName")
    private String metricName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="namespace")
    private NamespaceEnum namespace;

    public QueryMetricItemOptionParam withDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public QueryMetricItemOptionParam addDimensionsItem(Dimension dimensionsItem) {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Dimension>();
        }
        this.dimensions.add(dimensionsItem);
        return this;
    }

    public QueryMetricItemOptionParam withDimensions(Consumer<List<Dimension>> dimensionsSetter) {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Dimension>();
        }
        dimensionsSetter.accept(this.dimensions);
        return this;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public QueryMetricItemOptionParam withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public QueryMetricItemOptionParam withNamespace(NamespaceEnum namespace) {
        this.namespace = namespace;
        return this;
    }

    public NamespaceEnum getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceEnum namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryMetricItemOptionParam that = (QueryMetricItemOptionParam)obj;
        return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.metricName, that.metricName) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.metricName, this.namespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryMetricItemOptionParam {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class NamespaceEnum {
        public static final NamespaceEnum PAAS_CONTAINER = new NamespaceEnum("PAAS.CONTAINER");
        public static final NamespaceEnum PAAS_NODE = new NamespaceEnum("PAAS.NODE");
        public static final NamespaceEnum PAAS_SLA = new NamespaceEnum("PAAS.SLA");
        public static final NamespaceEnum PAAS_AGGR = new NamespaceEnum("PAAS.AGGR");
        public static final NamespaceEnum CUSTOMMETRICS = new NamespaceEnum("CUSTOMMETRICS");
        private static final Map<String, NamespaceEnum> STATIC_FIELDS = NamespaceEnum.createStaticFields();
        private String value;

        private static Map<String, NamespaceEnum> createStaticFields() {
            HashMap<String, NamespaceEnum> map = new HashMap<String, NamespaceEnum>();
            map.put("PAAS.CONTAINER", PAAS_CONTAINER);
            map.put("PAAS.NODE", PAAS_NODE);
            map.put("PAAS.SLA", PAAS_SLA);
            map.put("PAAS.AGGR", PAAS_AGGR);
            map.put("CUSTOMMETRICS", CUSTOMMETRICS);
            return Collections.unmodifiableMap(map);
        }

        NamespaceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NamespaceEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new NamespaceEnum(value));
        }

        public static NamespaceEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof NamespaceEnum) {
                return this.value.equals(((NamespaceEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

