/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MuteConfig {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ends_at")
    private Long endsAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="scope")
    private List<Integer> scope = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="starts_at")
    private Long startsAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;

    public MuteConfig withEndsAt(Long endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public void setEndsAt(Long endsAt) {
        this.endsAt = endsAt;
    }

    public MuteConfig withScope(List<Integer> scope) {
        this.scope = scope;
        return this;
    }

    public MuteConfig addScopeItem(Integer scopeItem) {
        if (this.scope == null) {
            this.scope = new ArrayList<Integer>();
        }
        this.scope.add(scopeItem);
        return this;
    }

    public MuteConfig withScope(Consumer<List<Integer>> scopeSetter) {
        if (this.scope == null) {
            this.scope = new ArrayList<Integer>();
        }
        scopeSetter.accept(this.scope);
        return this;
    }

    public List<Integer> getScope() {
        return this.scope;
    }

    public void setScope(List<Integer> scope) {
        this.scope = scope;
    }

    public MuteConfig withStartsAt(Long startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(Long startsAt) {
        this.startsAt = startsAt;
    }

    public MuteConfig withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MuteConfig that = (MuteConfig)obj;
        return Objects.equals(this.endsAt, that.endsAt) && Objects.equals(this.scope, that.scope) && Objects.equals(this.startsAt, that.startsAt) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.endsAt, this.scope, this.startsAt, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MuteConfig {\n");
        sb.append("    endsAt: ").append(this.toIndentedString(this.endsAt)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum FIXED = new TypeEnum("FIXED");
        public static final TypeEnum DAILY = new TypeEnum("DAILY");
        public static final TypeEnum WEEKLY = new TypeEnum("WEEKLY");
        public static final TypeEnum MONTHLY = new TypeEnum("MONTHLY");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("FIXED", FIXED);
            map.put("DAILY", DAILY);
            map.put("WEEKLY", WEEKLY);
            map.put("MONTHLY", MONTHLY);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

