/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Match {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key")
    private String key;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="operate")
    private OperateEnum operate;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private List<String> value = null;

    public Match withKey(String key) {
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Match withOperate(OperateEnum operate) {
        this.operate = operate;
        return this;
    }

    public OperateEnum getOperate() {
        return this.operate;
    }

    public void setOperate(OperateEnum operate) {
        this.operate = operate;
    }

    public Match withValue(List<String> value) {
        this.value = value;
        return this;
    }

    public Match addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    public Match withValue(Consumer<List<String>> valueSetter) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        valueSetter.accept(this.value);
        return this;
    }

    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Match that = (Match)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.operate, that.operate) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operate, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Match {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operate: ").append(this.toIndentedString(this.operate)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class OperateEnum {
        public static final OperateEnum EQUALS = new OperateEnum("EQUALS");
        public static final OperateEnum REGEX = new OperateEnum("REGEX");
        public static final OperateEnum EXIST = new OperateEnum("EXIST");
        private static final Map<String, OperateEnum> STATIC_FIELDS = OperateEnum.createStaticFields();
        private String value;

        private static Map<String, OperateEnum> createStaticFields() {
            HashMap<String, OperateEnum> map = new HashMap<String, OperateEnum>();
            map.put("EQUALS", EQUALS);
            map.put("REGEX", REGEX);
            map.put("EXIST", EXIST);
            return Collections.unmodifiableMap(map);
        }

        OperateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperateEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OperateEnum(value));
        }

        public static OperateEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OperateEnum) {
                return this.value.equals(((OperateEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

