/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class EventTriggerCondition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="event_name")
    private String eventName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_type")
    private TriggerTypeEnum triggerType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="aggregation_window")
    private Long aggregationWindow;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="operator")
    private String operator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="thresholds")
    private Map<String, Integer> thresholds = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="frequency")
    private String frequency;

    public EventTriggerCondition withEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public EventTriggerCondition withTriggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public TriggerTypeEnum getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerTypeEnum triggerType) {
        this.triggerType = triggerType;
    }

    public EventTriggerCondition withAggregationWindow(Long aggregationWindow) {
        this.aggregationWindow = aggregationWindow;
        return this;
    }

    public Long getAggregationWindow() {
        return this.aggregationWindow;
    }

    public void setAggregationWindow(Long aggregationWindow) {
        this.aggregationWindow = aggregationWindow;
    }

    public EventTriggerCondition withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public EventTriggerCondition withThresholds(Map<String, Integer> thresholds) {
        this.thresholds = thresholds;
        return this;
    }

    public EventTriggerCondition putThresholdsItem(String key, Integer thresholdsItem) {
        if (this.thresholds == null) {
            this.thresholds = new HashMap<String, Integer>();
        }
        this.thresholds.put(key, thresholdsItem);
        return this;
    }

    public EventTriggerCondition withThresholds(Consumer<Map<String, Integer>> thresholdsSetter) {
        if (this.thresholds == null) {
            this.thresholds = new HashMap<String, Integer>();
        }
        thresholdsSetter.accept(this.thresholds);
        return this;
    }

    public Map<String, Integer> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Map<String, Integer> thresholds) {
        this.thresholds = thresholds;
    }

    public EventTriggerCondition withFrequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventTriggerCondition that = (EventTriggerCondition)obj;
        return Objects.equals(this.eventName, that.eventName) && Objects.equals(this.triggerType, that.triggerType) && Objects.equals(this.aggregationWindow, that.aggregationWindow) && Objects.equals(this.operator, that.operator) && Objects.equals(this.thresholds, that.thresholds) && Objects.equals(this.frequency, that.frequency);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.triggerType, this.aggregationWindow, this.operator, this.thresholds, this.frequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventTriggerCondition {\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    triggerType: ").append(this.toIndentedString(this.triggerType)).append("\n");
        sb.append("    aggregationWindow: ").append(this.toIndentedString(this.aggregationWindow)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TriggerTypeEnum {
        public static final TriggerTypeEnum IMMEDIATELY = new TriggerTypeEnum("immediately");
        public static final TriggerTypeEnum ACCUMULATIVE = new TriggerTypeEnum("accumulative");
        private static final Map<String, TriggerTypeEnum> STATIC_FIELDS = TriggerTypeEnum.createStaticFields();
        private String value;

        private static Map<String, TriggerTypeEnum> createStaticFields() {
            HashMap<String, TriggerTypeEnum> map = new HashMap<String, TriggerTypeEnum>();
            map.put("immediately", IMMEDIATELY);
            map.put("accumulative", ACCUMULATIVE);
            return Collections.unmodifiableMap(map);
        }

        TriggerTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TriggerTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TriggerTypeEnum(value));
        }

        public static TriggerTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TriggerTypeEnum) {
                return this.value.equals(((TriggerTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

