/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class EventSeries {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="event_severity")
    private EventSeverityEnum eventSeverity;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="values")
    private List<Integer> values = null;

    public EventSeries withEventSeverity(EventSeverityEnum eventSeverity) {
        this.eventSeverity = eventSeverity;
        return this;
    }

    public EventSeverityEnum getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(EventSeverityEnum eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public EventSeries withValues(List<Integer> values) {
        this.values = values;
        return this;
    }

    public EventSeries addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    public EventSeries withValues(Consumer<List<Integer>> valuesSetter) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        valuesSetter.accept(this.values);
        return this;
    }

    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventSeries that = (EventSeries)obj;
        return Objects.equals(this.eventSeverity, that.eventSeverity) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.eventSeverity, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSeries {\n");
        sb.append("    eventSeverity: ").append(this.toIndentedString(this.eventSeverity)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EventSeverityEnum {
        public static final EventSeverityEnum CRITICAL = new EventSeverityEnum("Critical");
        public static final EventSeverityEnum MAJOR = new EventSeverityEnum("Major");
        public static final EventSeverityEnum MINOR = new EventSeverityEnum("Minor");
        public static final EventSeverityEnum INFO = new EventSeverityEnum("Info");
        private static final Map<String, EventSeverityEnum> STATIC_FIELDS = EventSeverityEnum.createStaticFields();
        private String value;

        private static Map<String, EventSeverityEnum> createStaticFields() {
            HashMap<String, EventSeverityEnum> map = new HashMap<String, EventSeverityEnum>();
            map.put("Critical", CRITICAL);
            map.put("Major", MAJOR);
            map.put("Minor", MINOR);
            map.put("Info", INFO);
            return Collections.unmodifiableMap(map);
        }

        EventSeverityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventSeverityEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EventSeverityEnum(value));
        }

        public static EventSeverityEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EventSeverityEnum) {
                return this.value.equals(((EventSeverityEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

