/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.aom.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.aom.v2.model.EventTriggerCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class EventAlarmSpec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="alarm_source")
    private AlarmSourceEnum alarmSource;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="event_source")
    private String eventSource;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="monitor_objects")
    private List<Map<String, String>> monitorObjects = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_conditions")
    private List<EventTriggerCondition> triggerConditions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="alarm_rule_template_bind_enable")
    private Boolean alarmRuleTemplateBindEnable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="alarm_rule_template_id")
    private String alarmRuleTemplateId;

    public EventAlarmSpec withAlarmSource(AlarmSourceEnum alarmSource) {
        this.alarmSource = alarmSource;
        return this;
    }

    public AlarmSourceEnum getAlarmSource() {
        return this.alarmSource;
    }

    public void setAlarmSource(AlarmSourceEnum alarmSource) {
        this.alarmSource = alarmSource;
    }

    public EventAlarmSpec withEventSource(String eventSource) {
        this.eventSource = eventSource;
        return this;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public EventAlarmSpec withMonitorObjects(List<Map<String, String>> monitorObjects) {
        this.monitorObjects = monitorObjects;
        return this;
    }

    public EventAlarmSpec addMonitorObjectsItem(Map<String, String> monitorObjectsItem) {
        if (this.monitorObjects == null) {
            this.monitorObjects = new ArrayList<Map<String, String>>();
        }
        this.monitorObjects.add(monitorObjectsItem);
        return this;
    }

    public EventAlarmSpec withMonitorObjects(Consumer<List<Map<String, String>>> monitorObjectsSetter) {
        if (this.monitorObjects == null) {
            this.monitorObjects = new ArrayList<Map<String, String>>();
        }
        monitorObjectsSetter.accept(this.monitorObjects);
        return this;
    }

    public List<Map<String, String>> getMonitorObjects() {
        return this.monitorObjects;
    }

    public void setMonitorObjects(List<Map<String, String>> monitorObjects) {
        this.monitorObjects = monitorObjects;
    }

    public EventAlarmSpec withTriggerConditions(List<EventTriggerCondition> triggerConditions) {
        this.triggerConditions = triggerConditions;
        return this;
    }

    public EventAlarmSpec addTriggerConditionsItem(EventTriggerCondition triggerConditionsItem) {
        if (this.triggerConditions == null) {
            this.triggerConditions = new ArrayList<EventTriggerCondition>();
        }
        this.triggerConditions.add(triggerConditionsItem);
        return this;
    }

    public EventAlarmSpec withTriggerConditions(Consumer<List<EventTriggerCondition>> triggerConditionsSetter) {
        if (this.triggerConditions == null) {
            this.triggerConditions = new ArrayList<EventTriggerCondition>();
        }
        triggerConditionsSetter.accept(this.triggerConditions);
        return this;
    }

    public List<EventTriggerCondition> getTriggerConditions() {
        return this.triggerConditions;
    }

    public void setTriggerConditions(List<EventTriggerCondition> triggerConditions) {
        this.triggerConditions = triggerConditions;
    }

    public EventAlarmSpec withAlarmRuleTemplateBindEnable(Boolean alarmRuleTemplateBindEnable) {
        this.alarmRuleTemplateBindEnable = alarmRuleTemplateBindEnable;
        return this;
    }

    public Boolean getAlarmRuleTemplateBindEnable() {
        return this.alarmRuleTemplateBindEnable;
    }

    public void setAlarmRuleTemplateBindEnable(Boolean alarmRuleTemplateBindEnable) {
        this.alarmRuleTemplateBindEnable = alarmRuleTemplateBindEnable;
    }

    public EventAlarmSpec withAlarmRuleTemplateId(String alarmRuleTemplateId) {
        this.alarmRuleTemplateId = alarmRuleTemplateId;
        return this;
    }

    public String getAlarmRuleTemplateId() {
        return this.alarmRuleTemplateId;
    }

    public void setAlarmRuleTemplateId(String alarmRuleTemplateId) {
        this.alarmRuleTemplateId = alarmRuleTemplateId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventAlarmSpec that = (EventAlarmSpec)obj;
        return Objects.equals(this.alarmSource, that.alarmSource) && Objects.equals(this.eventSource, that.eventSource) && Objects.equals(this.monitorObjects, that.monitorObjects) && Objects.equals(this.triggerConditions, that.triggerConditions) && Objects.equals(this.alarmRuleTemplateBindEnable, that.alarmRuleTemplateBindEnable) && Objects.equals(this.alarmRuleTemplateId, that.alarmRuleTemplateId);
    }

    public int hashCode() {
        return Objects.hash(this.alarmSource, this.eventSource, this.monitorObjects, this.triggerConditions, this.alarmRuleTemplateBindEnable, this.alarmRuleTemplateId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventAlarmSpec {\n");
        sb.append("    alarmSource: ").append(this.toIndentedString(this.alarmSource)).append("\n");
        sb.append("    eventSource: ").append(this.toIndentedString(this.eventSource)).append("\n");
        sb.append("    monitorObjects: ").append(this.toIndentedString(this.monitorObjects)).append("\n");
        sb.append("    triggerConditions: ").append(this.toIndentedString(this.triggerConditions)).append("\n");
        sb.append("    alarmRuleTemplateBindEnable: ").append(this.toIndentedString(this.alarmRuleTemplateBindEnable)).append("\n");
        sb.append("    alarmRuleTemplateId: ").append(this.toIndentedString(this.alarmRuleTemplateId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class AlarmSourceEnum {
        public static final AlarmSourceEnum SYSTEMEVENT = new AlarmSourceEnum("systemEvent");
        public static final AlarmSourceEnum CUSTOMEVENT = new AlarmSourceEnum("customEvent");
        private static final Map<String, AlarmSourceEnum> STATIC_FIELDS = AlarmSourceEnum.createStaticFields();
        private String value;

        private static Map<String, AlarmSourceEnum> createStaticFields() {
            HashMap<String, AlarmSourceEnum> map = new HashMap<String, AlarmSourceEnum>();
            map.put("systemEvent", SYSTEMEVENT);
            map.put("customEvent", CUSTOMEVENT);
            return Collections.unmodifiableMap(map);
        }

        AlarmSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlarmSourceEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AlarmSourceEnum(value));
        }

        public static AlarmSourceEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AlarmSourceEnum) {
                return this.value.equals(((AlarmSourceEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

