/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.AbstractRequestConvertor;
import com.obs.services.internal.service.ObsObjectBaseService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.util.HashMap;
import shade.okhttp3.Response;

public abstract class ObsMultipartObjectService
extends ObsObjectBaseService {
    protected InitiateMultipartUploadResult initiateMultipartUploadImpl(InitiateMultipartUploadRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transInitiateMultipartUploadRequest(request);
        this.prepareRESTHeaderAcl(request.getBucketName(), result.getHeaders(), request.getAcl());
        NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
        Response response = this.performRequest(newTransResult, true, false, false);
        this.verifyResponseContentType(response);
        InitiateMultipartUploadResult multipartUpload = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.InitiateMultipartUploadHandler.class, true).getInitiateMultipartUploadResult();
        this.setHeadersAndStatus(multipartUpload, response);
        return multipartUpload;
    }

    protected HeaderResponse abortMultipartUploadImpl(AbortMultipartUploadRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected CompleteMultipartUploadResult completeMultipartUploadImpl(CompleteMultipartUploadRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("uploadId", request.getUploadId());
        if (request.getEncodingType() != null) {
            requestParams.put("encoding-type", request.getEncodingType());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = this.getIConvertor(request.getBucketName()).transCompleteMultipartUpload(request.getPartEtag());
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        NewTransResult transResult = this.transObjectRequest(request);
        transResult.setParams(requestParams);
        transResult.setHeaders(headers);
        transResult.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(transResult, true, false, false);
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CompleteMultipartUploadHandler.class, true);
        String versionId = response.header(this.getIHeaders(request.getBucketName()).versionIdHeader());
        CompleteMultipartUploadResult ret = new CompleteMultipartUploadResult(handler.getBucketName(), handler.getObjectKey(), handler.getEtag(), handler.getLocation(), versionId, this.getObjectUrl(handler.getBucketName(), handler.getObjectKey()));
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected MultipartUploadListing listMultipartUploadsImpl(ListMultipartUploadsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            requestParameters.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            requestParameters.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxUploads() != null) {
            requestParameters.put("max-uploads", request.getMaxUploads().toString());
        }
        if (request.getKeyMarker() != null) {
            requestParameters.put("key-marker", request.getKeyMarker());
        }
        if (request.getUploadIdMarker() != null) {
            requestParameters.put("upload-id-marker", request.getUploadIdMarker());
        }
        if (request.getEncodingType() != null) {
            requestParameters.put("encoding-type", request.getEncodingType());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListMultipartUploadsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListMultipartUploadsHandler.class, true);
        MultipartUploadListing listResult = new MultipartUploadListing.Builder().bucketName(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName()).keyMarker(handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker()).uploadIdMarker(handler.getUploadIdMarker() == null ? request.getUploadIdMarker() : handler.getUploadIdMarker()).nextKeyMarker(handler.getNextKeyMarker()).nextUploadIdMarker(handler.getNextUploadIdMarker()).prefix(handler.getPrefix() == null ? request.getPrefix() : handler.getPrefix()).maxUploads(handler.getMaxUploads()).truncated(handler.isTruncated()).multipartTaskList(handler.getMultipartUploadList()).delimiter(handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter()).commonPrefixes(handler.getCommonPrefixes().toArray(new String[handler.getCommonPrefixes().size()])).builder();
        this.setHeadersAndStatus(listResult, httpResponse);
        return listResult;
    }

    protected ListPartsResult listPartsImpl(ListPartsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        if (null != request.getMaxParts()) {
            requestParameters.put("max-parts", request.getMaxParts().toString());
        }
        if (null != request.getPartNumberMarker()) {
            requestParameters.put("part-number-marker", request.getPartNumberMarker().toString());
        }
        if (null != request.getEncodingType()) {
            requestParameters.put("encoding-type", request.getEncodingType());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListPartsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListPartsHandler.class, true);
        ListPartsResult result = new ListPartsResult.Builder().bucket(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName()).key(handler.getObjectKey() == null ? request.getObjectKey() : handler.getObjectKey()).uploadId(handler.getUploadId() == null ? request.getUploadId() : handler.getUploadId()).initiator(handler.getInitiator()).owner(handler.getOwner()).storageClass(StorageClassEnum.getValueFromCode(handler.getStorageClass())).multipartList(handler.getMultiPartList()).maxParts(handler.getMaxParts()).isTruncated(handler.isTruncated()).partNumberMarker((String)(handler.getPartNumberMarker() == null ? (request.getPartNumberMarker() == null ? null : request.getPartNumberMarker().toString()) : handler.getPartNumberMarker())).nextPartNumberMarker(handler.getNextPartNumberMarker()).builder();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadPartResult uploadPartImpl(UploadPartRequest request) throws ServiceException {
        Response response;
        AbstractRequestConvertor.TransResult result = null;
        try {
            result = this.transUploadPartRequest(request);
            NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
            response = this.performRequest(newTransResult);
        }
        finally {
            if (result != null && result.getBody() != null && request.isAutoClose()) {
                RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                ServiceUtils.closeStream(entity);
            }
        }
        UploadPartResult ret = new UploadPartResult();
        ret.setEtag(response.header("ETag"));
        ret.setPartNumber(request.getPartNumber());
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected CopyPartResult copyPartImpl(CopyPartRequest request) throws ServiceException {
        AbstractRequestConvertor.TransResult result = this.transCopyPartRequest(request);
        NewTransResult newTransResult = this.transObjectRequestWithResult(result, request);
        Response response = this.performRequest(newTransResult, true, false, false);
        this.verifyResponseContentType(response);
        CopyPartResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyPartResultHandler.class, true).getCopyPartResult(request.getPartNumber());
        this.setHeadersAndStatus(ret, response);
        return ret;
    }
}

