/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.exception.ObsException;
import com.obs.services.model.ISecurityKey;
import java.util.ArrayList;
import java.util.List;

public class DefaultCredentialsProviderChain
implements IObsCredentialsProvider {
    private static final ILogger ILOG = LoggerBuilder.getLogger(DefaultCredentialsProviderChain.class);
    private IObsCredentialsProvider lastProvider = null;
    private boolean reused = true;
    private final List<IObsCredentialsProvider> credentialsProviders = new ArrayList<IObsCredentialsProvider>(2);

    public DefaultCredentialsProviderChain(IObsCredentialsProvider ... credentialsProviders) {
        if (credentialsProviders == null || credentialsProviders.length == 0) {
            throw new IllegalArgumentException("No credential providers specified");
        }
        for (IObsCredentialsProvider provider : credentialsProviders) {
            this.credentialsProviders.add(provider);
        }
    }

    public DefaultCredentialsProviderChain(boolean reused, IObsCredentialsProvider ... credentialsProviders) {
        this(credentialsProviders);
        this.reused = reused;
    }

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        throw new UnsupportedOperationException("OBSCredentialsProviderChain class does not support this method");
    }

    @Override
    public ISecurityKey getSecurityKey() {
        if (this.reused && this.lastProvider != null) {
            return this.lastProvider.getSecurityKey();
        }
        for (IObsCredentialsProvider provider : this.credentialsProviders) {
            try {
                ISecurityKey credentials = provider.getSecurityKey();
                if (credentials.getAccessKey() == null || credentials.getSecretKey() == null) continue;
                ILOG.debug("Loading credentials from " + provider.toString());
                this.lastProvider = provider;
                return this.lastProvider.getSecurityKey();
            }
            catch (Exception e) {
                if (!ILOG.isWarnEnabled()) continue;
                ILOG.warn("Loading credentials from " + provider.toString(), e);
            }
        }
        if (ILOG.isErrorEnabled()) {
            ILOG.error("No credential providers specified");
        }
        this.lastProvider = null;
        throw new ObsException("No credential providers specified");
    }

    public void refresh() {
        this.lastProvider = null;
    }
}

